/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class UDPConnectBackVendorMessage
extends VendorMessage {
    public static final int VERSION = 2;
    private final int _port;
    private final GUID _guid;

    UDPConnectBackVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_GTKG_VENDOR_ID, 7, n, byArray2);
        try {
            byArray2 = this.getPayload();
            switch (this.getVersion()) {
                case 1: {
                    if (byArray2.length != 18) {
                        throw new BadPacketException("invalid version1 payload");
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    this._port = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
                    byte[] byArray3 = new byte[16];
                    byteArrayInputStream.read(byArray3, 0, byArray3.length);
                    this._guid = new GUID(byArray3);
                    break;
                }
                case 2: {
                    if (byArray2.length != 2) {
                        throw new BadPacketException("invalid version2 payload");
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                    this._port = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
                    this._guid = new GUID(super.getGUID());
                    break;
                }
                default: {
                    throw new BadPacketException("Unsupported Version");
                }
            }
            if (!NetworkUtils.isValidPort(this._port)) {
                throw new BadPacketException("invalid connectback port.");
            }
        }
        catch (IOException iOException) {
            throw new BadPacketException("Couldn't read from a ByteStream!!!");
        }
    }

    public UDPConnectBackVendorMessage(int n, GUID gUID) {
        super(F_GTKG_VENDOR_ID, 7, 1, UDPConnectBackVendorMessage.derivePayload(n, gUID));
        this._port = n;
        this._guid = gUID;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    public GUID getConnectBackGUID() {
        return this._guid;
    }

    private static byte[] derivePayload(int n, GUID gUID) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            byteArrayOutputStream.write(gUID.bytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        SentMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(this);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

