/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class UpdateResponse
extends VendorMessage {
    private static final int NON_GGEP_VERSION = 1;
    public static final int VERSION = 2;
    private byte[] update;

    UpdateResponse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        block7: {
            super(byArray, by, by2, F_LIME_VENDOR_ID, 27, n, byArray2);
            if (n == 1) {
                this.update = byArray2;
            } else {
                try {
                    GGEP gGEP = new GGEP(byArray2, 0, null);
                    if (gGEP.hasKey("U")) {
                        this.update = gGEP.getBytes("U");
                        break block7;
                    }
                    if (gGEP.hasKey("C")) {
                        this.update = gGEP.getBytes("C");
                        break block7;
                    }
                    throw new BadPacketException("no update in GGEP?");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException("bad ggep property");
                }
                catch (BadGGEPBlockException badGGEPBlockException) {
                    this.update = byArray2;
                }
            }
        }
    }

    private UpdateResponse(byte[] byArray, int n) {
        super(F_LIME_VENDOR_ID, 27, n, byArray);
    }

    public static UpdateResponse createUpdateResponse(byte[] byArray, UpdateRequest updateRequest) {
        if (!updateRequest.hasGGEP()) {
            return new UpdateResponse(byArray, 1);
        }
        GGEP gGEP = new GGEP(true);
        if (updateRequest.requestsCompressed()) {
            gGEP.putCompressed("C", byArray);
        } else {
            gGEP.put("U", byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return new UpdateResponse(byteArrayOutputStream.toByteArray(), 2);
    }

    public byte[] getUpdate() {
        return this.update;
    }
}

