/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.DHKey;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.DHKeyEx;
import org.logi.crypto.protocols.InterKeyExServer;

public class DHKeyExServer
extends DHKeyEx
implements InterKeyExServer {
    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        try {
            byte[] byArray2;
            if (byArray != null) {
                this.hisPublic = new BigInteger(1, byArray);
                byArray2 = this.hisPublic.modPow(this.myPrivate, this.m).toByteArray();
                try {
                    this.sessionKey = Crypto.makeSessionKey(this.keyType, byArray2);
                    this.keyDecided = true;
                }
                catch (InvalidCDSException invalidCDSException) {
                    throw new CryptoProtocolException(invalidCDSException.getMessage());
                }
            }
            if ((byArray2 = this.myPublic.toByteArray()).length == this.modSize / 8) {
                return byArray2;
            }
            byte[] byArray3 = new byte[this.modSize / 8];
            int n = Math.min(byArray2.length, this.modSize / 8);
            System.arraycopy(byArray2, byArray2.length - n, byArray3, byArray3.length - n, n);
            return byArray3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public DHKeyExServer(DHKey dHKey, String string) throws KeyException {
        super(dHKey, string);
    }

    public DHKeyExServer(int n, String string) {
        super(n, string);
    }
}

