/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.sign;

import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;

public class Signature
extends Crypto {
    private byte[] s;
    private Fingerprint keyPrint;
    private String fingAlg;

    public static Signature parseCDS(String string) throws InvalidCDSException {
        try {
            int n;
            int n2 = 0;
            int n3 = n = string.indexOf(44);
            while (n3 > 0 && Character.isWhitespace(string.charAt(n3 - 1))) {
                --n3;
            }
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            String string2 = string.substring(n2, n3);
            n2 = n + 1;
            n3 = n = string.indexOf(44, n + 1);
            while (n3 > 0 && Character.isWhitespace(string.charAt(n3 - 1))) {
                --n3;
            }
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            String string3 = string.substring(n2, n3);
            n2 = n + 1;
            n3 = n = string.lastIndexOf(41);
            while (n3 > 0 && Character.isWhitespace(string.charAt(n3 - 1))) {
                --n3;
            }
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            String string4 = string.substring(n2, n3 + 1);
            return new Signature(Crypto.fromHexString(string2), string3, (Fingerprint)Crypto.fromString(string4));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new InvalidCDSException("Wrong number of arguments to Signature()");
        }
    }

    public String getFingerprintAlgorithm() {
        return this.fingAlg;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.s.length];
        System.arraycopy(this.s, 0, byArray, 0, this.s.length);
        return byArray;
    }

    public Fingerprint getKeyPrint() {
        return this.keyPrint;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Signature(");
        stringBuffer.append(this.s == null ? "null" : Crypto.hexString(this.s));
        stringBuffer.append(',');
        stringBuffer.append(this.fingAlg == null ? "null" : this.fingAlg);
        stringBuffer.append(',');
        stringBuffer.append(this.keyPrint == null ? "null" : this.keyPrint.toString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Signature(byte[] byArray, String string, Fingerprint fingerprint) {
        this.s = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.s, 0, byArray.length);
        this.fingAlg = string;
        this.keyPrint = fingerprint;
    }
}

