/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionChecker
implements Runnable {
    private volatile boolean _connected;
    private int _unsuccessfulAttempts;
    private boolean _triedSP2Workaround;
    private static final Log LOG;
    private static String[] STANDARD_HOSTS;
    private static ConnectionChecker current;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.connection.ConnectionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        STANDARD_HOSTS = new String[]{"www.wanadoo.fr", "www.tiscali.com", "www.ntt.com", "www.tonline.com", "www.download.com", "www.ibm.com", "www.sun.com", "www.apple.com", "www.ebay.com", "www.sun.com", "www.monster.com", "www.uunet.com", "www.real.com", "www.microsoft.com", "www.sco.com", "www.google.com", "www.cnn.com", "www.amazon.com", "www.espn.com", "www.yahoo.com", "www.oracle.com", "www.dell.com", "www.ge.com", "www.sprint.com", "www.att.com", "www.mci.com", "www.cisco.com", "www.intel.com", "www.motorola.com", "www.hp.com", "www.gateway.com", "www.sony.com", "www.ford.com", "www.gm.com", "www.aol.com", "www.verizon.com", "www.passport.com", "www.go.com", "www.overture.com", "www.earthlink.net", "www.bellsouth.net", "www.excite.com", "www.paypal.com", "www.altavista.com", "www.weather.com", "www.mapquest.com", "www.geocities.com", "www.juno.com", "www.msnbc.com", "www.lycos.com", "www.comcast.com"};
    }

    private ConnectionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionChecker checkForLiveConnection() {
        LOG.trace((Object)"checking for live connection");
        boolean bl = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.connection.ConnectionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = clazz;
        synchronized (clazz) {
            if (current == null) {
                current = new ConnectionChecker();
                bl = true;
            }
            ConnectionChecker connectionChecker = current;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl) {
                object = new ManagedThread(connectionChecker, "check for live connection");
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
            }
            return connectionChecker;
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 191->195)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void trySP2Workaround() {
        if (this.hasNoTransfers() && this.udpIsDead()) {
            return;
        }
        this.killAndSleep();
    }

    private boolean hasNoTransfers() {
        RouterService.getDownloadManager().measureBandwidth();
        float f = RouterService.getDownloadManager().getMeasuredBandwidth();
        if (f != 0.0f) {
            return false;
        }
        RouterService.getUploadManager().measureBandwidth();
        float f2 = RouterService.getUploadManager().getMeasuredBandwidth();
        return f2 == 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean udpIsDead() {
        PingRequest pingRequest = PingRequest.createUDPPing();
        Collection collection = RouterService.getPreferencedHosts(false, "en", 50);
        UDPPinger uDPPinger = RouterService.getHostCatcher().getPinger();
        UDPChecker uDPChecker = new UDPChecker();
        uDPPinger.rank(collection, uDPChecker, uDPChecker, pingRequest);
        long l = System.currentTimeMillis();
        UDPChecker uDPChecker2 = uDPChecker;
        synchronized (uDPChecker2) {
            try {
                int n = 0;
                while (n < 5) {
                    uDPChecker.wait(1000L);
                    if (UDPService.instance().getLastReceivedTime() > l) {
                        uDPChecker.received = true;
                        return false;
                    }
                    ++n;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!uDPChecker.received) return true;
        return false;
    }

    private void killAndSleep() {
        RouterService.disconnect();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        this._unsuccessfulAttempts = 0;
    }

    public boolean hasConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectToHost(String string) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connecting to: " + string));
        }
        Socket socket = null;
        try {
            try {
                InetAddress.getByName(string);
                socket = Sockets.connectHardTimeout(string, 80, 20000);
                this._connected = true;
            }
            catch (IOException iOException) {
                ++this._unsuccessfulAttempts;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IOUtils.close(socket);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        IOUtils.close(socket);
    }

    private class UDPChecker
    implements MessageListener,
    Cancellable {
        volatile boolean received;

        UDPChecker() {
        }

        public boolean isCancelled() {
            return this.received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(Message message, ReplyHandler replyHandler) {
            this.received = true;
            UDPChecker uDPChecker = this;
            synchronized (uDPChecker) {
                this.notify();
            }
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }
}

