/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.DualIterator;
import com.limegroup.gnutella.util.IpPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingRanker
extends SourceRanker
implements MessageListener,
Cancellable {
    private static final Log LOG;
    private UDPPinger pinger = new UDPPinger();
    private Set newHosts;
    private TreeMap pingedHosts = new TreeMap(IpPort.COMPARATOR);
    private Set testedLocations = new HashSet();
    private TreeSet verifiedHosts;
    private URN sha1;
    private GUID myGUID;
    private boolean running;
    private long lastPingTime;
    private static final Comparator RFD_COMPARATOR;
    private static final Comparator ALT_DEPRIORITIZER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.PingRanker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        RFD_COMPARATOR = new RFDComparator();
        ALT_DEPRIORITIZER = new RFDAltDeprioritizer();
    }

    protected PingRanker() {
        this.newHosts = new HashSet();
        this.verifiedHosts = new TreeSet(RFD_COMPARATOR);
    }

    public synchronized boolean addToPool(Collection collection) {
        ArrayList arrayList = collection instanceof List ? (ArrayList)collection : new ArrayList(collection);
        Collections.sort(arrayList, ALT_DEPRIORITIZER);
        return this.addInternal(arrayList);
    }

    private boolean addInternal(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.addInternal((RemoteFileDesc)iterator.next())) continue;
            bl = true;
        }
        this.pingNewHosts();
        return bl;
    }

    public synchronized boolean addToPool(RemoteFileDesc remoteFileDesc) {
        boolean bl = this.addInternal(remoteFileDesc);
        this.pingNewHosts();
        return bl;
    }

    private boolean addInternal(RemoteFileDesc remoteFileDesc) {
        if (this.sha1 == null) {
            if (remoteFileDesc.getSHA1Urn() != null) {
                this.sha1 = remoteFileDesc.getSHA1Urn();
            } else {
                return this.testedLocations.add(remoteFileDesc);
            }
        }
        if (this.running && this.knowsAboutHost(remoteFileDesc)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding new host " + remoteFileDesc + " " + remoteFileDesc.getPushAddr()));
        }
        boolean bl = false;
        bl = remoteFileDesc.isReplyToMulticast() ? this.verifiedHosts.add(remoteFileDesc) : this.newHosts.add(remoteFileDesc);
        bl |= !this.running;
        if (this.myGUID == null && this.meshHandler != null) {
            this.myGUID = new GUID(GUID.makeGuid());
            RouterService.getMessageRouter().registerMessageListener(this.myGUID.bytes(), this);
        }
        return bl;
    }

    private boolean knowsAboutHost(RemoteFileDesc remoteFileDesc) {
        return this.newHosts.contains(remoteFileDesc) || this.verifiedHosts.contains(remoteFileDesc) || this.testedLocations.contains(remoteFileDesc);
    }

    public synchronized RemoteFileDesc getBest() throws NoSuchElementException {
        RemoteFileDesc remoteFileDesc;
        if (!this.hasMore()) {
            return null;
        }
        if (!this.verifiedHosts.isEmpty()) {
            LOG.debug((Object)"getting a verified host");
            remoteFileDesc = (RemoteFileDesc)this.verifiedHosts.first();
            this.verifiedHosts.remove(remoteFileDesc);
        } else {
            LOG.debug((Object)"getting a non-verified host");
            DualIterator dualIterator = new DualIterator(this.testedLocations.iterator(), this.newHosts.iterator());
            remoteFileDesc = LegacyRanker.getBest(dualIterator);
            this.newHosts.remove(remoteFileDesc);
            this.testedLocations.remove(remoteFileDesc);
            if (remoteFileDesc.needsPush()) {
                Iterator iterator = remoteFileDesc.getPushProxies().iterator();
                while (iterator.hasNext()) {
                    this.pingedHosts.remove(iterator.next());
                }
            } else {
                this.pingedHosts.remove(remoteFileDesc);
            }
        }
        this.pingNewHosts();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("the best host we came up with is " + remoteFileDesc + " " + remoteFileDesc.getPushAddr()));
        }
        return remoteFileDesc;
    }

    private void pingNewHosts() {
        if (this.isCancelled()) {
            return;
        }
        if (!this.hasNonBusy()) {
            return;
        }
        if (this.sha1 == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastPingTime < (long)DownloadSettings.WORKER_INTERVAL.getValue()) {
            return;
        }
        HeadPing headPing = new HeadPing(this.myGUID, this.sha1, PingRanker.getPingFlags());
        int n = DownloadSettings.PING_BATCH.getValue();
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(n);
        int n2 = 0;
        Iterator iterator = this.newHosts.iterator();
        while (iterator.hasNext() && n2 < n) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc.isBusy(l)) continue;
            iterator.remove();
            if (remoteFileDesc.needsPush()) {
                if (remoteFileDesc.getPushProxies().size() > 0 && remoteFileDesc.getSHA1Urn() != null) {
                    this.pingProxies(remoteFileDesc);
                }
            } else {
                this.pingedHosts.put(remoteFileDesc, remoteFileDesc);
                arrayList.add(remoteFileDesc);
            }
            this.testedLocations.add(remoteFileDesc);
            ++n2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\nverified hosts " + this.verifiedHosts.size() + "\npingedHosts " + this.pingedHosts.values().size() + "\nnewHosts " + this.newHosts.size() + "\npinging hosts: " + n2));
        }
        this.pinger.rank(arrayList, null, this, headPing);
        this.lastPingTime = l;
    }

    protected Collection getPotentiallyBusyHosts() {
        return this.newHosts;
    }

    private void pingProxies(RemoteFileDesc remoteFileDesc) {
        if (RouterService.acceptedIncomingConnection() || RouterService.getUdpService().canDoFWT() && remoteFileDesc.supportsFWTransfer()) {
            HeadPing headPing = new HeadPing(this.myGUID, remoteFileDesc.getSHA1Urn(), new GUID(remoteFileDesc.getPushAddr().getClientGUID()), PingRanker.getPingFlags());
            Iterator iterator = remoteFileDesc.getPushProxies().iterator();
            while (iterator.hasNext()) {
                this.pingedHosts.put(iterator.next(), remoteFileDesc);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pinging push location " + remoteFileDesc.getPushAddr()));
            }
            this.pinger.rank(remoteFileDesc.getPushProxies(), null, this, headPing);
        }
    }

    private static int getPingFlags() {
        int n = 3;
        if (RouterService.acceptedIncomingConnection() || RouterService.getUdpService().canDoFWT()) {
            n |= 4;
        }
        return n;
    }

    public synchronized boolean hasMore() {
        return !this.verifiedHosts.isEmpty() || !this.newHosts.isEmpty() || !this.testedLocations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Message message, ReplyHandler replyHandler) {
        MeshHandler meshHandler;
        RemoteFileDesc remoteFileDesc;
        Set set = null;
        PingRanker pingRanker = this;
        synchronized (pingRanker) {
            if (!this.running) {
                return;
            }
            if (!(message instanceof HeadPong)) {
                return;
            }
            HeadPong headPong = (HeadPong)message;
            if (!this.pingedHosts.containsKey(replyHandler)) {
                return;
            }
            remoteFileDesc = (RemoteFileDesc)this.pingedHosts.remove(replyHandler);
            this.testedLocations.remove(remoteFileDesc);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("received a pong " + headPong + " from " + replyHandler + " for rfd " + remoteFileDesc + " with PE " + remoteFileDesc.getPushAddr()));
            }
            if (!headPong.hasFile() && !headPong.isGGEPPong() && remoteFileDesc.needsPush()) {
                return;
            }
            if (headPong.isFirewalled()) {
                Iterator iterator = remoteFileDesc.getPushProxies().iterator();
                while (iterator.hasNext()) {
                    this.pingedHosts.remove(iterator.next());
                }
            }
            meshHandler = this.meshHandler;
            if (headPong.hasFile()) {
                headPong.updateRFD(remoteFileDesc);
                if (remoteFileDesc.isBusy()) {
                    this.newHosts.add(remoteFileDesc);
                } else {
                    this.verifiedHosts.add(remoteFileDesc);
                }
                set = headPong.getAllLocsRFD(remoteFileDesc);
            }
        }
        if (set == null) {
            meshHandler.informMesh(remoteFileDesc, false);
        } else {
            meshHandler.addPossibleSources(set);
        }
    }

    public synchronized void registered(byte[] byArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ranker registered with guid " + new GUID(byArray).toHexString()), (Throwable)new Exception());
        }
        this.running = true;
    }

    public synchronized void unregistered(byte[] byArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ranker unregistered with guid " + new GUID(byArray).toHexString()), (Throwable)new Exception());
        }
        this.running = false;
        this.newHosts.addAll(this.verifiedHosts);
        this.newHosts.addAll(this.testedLocations);
        this.verifiedHosts.clear();
        this.pingedHosts.clear();
        this.testedLocations.clear();
        this.lastPingTime = 0L;
    }

    public synchronized boolean isCancelled() {
        return !this.running || this.verifiedHosts.size() >= DownloadSettings.MAX_VERIFIED_HOSTS.getValue();
    }

    protected synchronized void clearState() {
        if (this.myGUID != null) {
            RouterService.getMessageRouter().unregisterMessageListener(this.myGUID.bytes(), this);
            this.myGUID = null;
        }
    }

    protected synchronized Collection getShareableHosts() {
        ArrayList arrayList = new ArrayList(this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size());
        arrayList.addAll(this.verifiedHosts);
        arrayList.addAll(this.newHosts);
        arrayList.addAll(this.testedLocations);
        return arrayList;
    }

    public synchronized int getNumKnownHosts() {
        return this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size();
    }

    private static final class RFDComparator
    implements Comparator {
        RFDComparator() {
        }

        public int compare(Object object, Object object2) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
            RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)object2;
            if (remoteFileDesc.isReplyToMulticast() != remoteFileDesc2.isReplyToMulticast()) {
                if (remoteFileDesc.isReplyToMulticast()) {
                    return -1;
                }
                return 1;
            }
            if (remoteFileDesc.getQueueStatus() > remoteFileDesc2.getQueueStatus()) {
                return 1;
            }
            if (remoteFileDesc.getQueueStatus() < remoteFileDesc2.getQueueStatus()) {
                return -1;
            }
            if (remoteFileDesc.needsPush() != remoteFileDesc2.needsPush()) {
                if (remoteFileDesc.needsPush()) {
                    return -1;
                }
                return 1;
            }
            if (remoteFileDesc.isPartialSource() != remoteFileDesc2.isPartialSource()) {
                if (remoteFileDesc.isPartialSource()) {
                    return -1;
                }
                return 1;
            }
            return remoteFileDesc.hashCode() - remoteFileDesc2.hashCode();
        }
    }

    private static final class RFDAltDeprioritizer
    implements Comparator {
        RFDAltDeprioritizer() {
        }

        public int compare(Object object, Object object2) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
            RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)object2;
            if (remoteFileDesc.isFromAlternateLocation() != remoteFileDesc2.isFromAlternateLocation()) {
                if (remoteFileDesc.isFromAlternateLocation()) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }
}

