/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.IOErrorObserver;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.ReadObserver;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.WriteObserver;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NIODispatcher
implements Runnable {
    private static final Log LOG;
    private static final NIODispatcher INSTANCE;
    private static final long MAXIMUM_ATTACHMENT_HITS = 10000L;
    private static final long SPIN_AMOUNT = 5000L;
    private static final int MAX_IGNORES = 5;
    private final Thread dispatchThread;
    private Selector selector = null;
    private long iteration = 0L;
    private final Object Q_LOCK = new Object();
    private final Collection REGISTER = new LinkedList();
    private final Collection LATER = new LinkedList();
    private volatile List THROTTLE = new ArrayList();
    private final ArrayList UNLOCKED = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.NIODispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new NIODispatcher();
    }

    public static final NIODispatcher instance() {
        return INSTANCE;
    }

    private NIODispatcher() {
        boolean bl = false;
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (!bl) {
            this.dispatchThread = new ManagedThread(this, "NIODispatcher");
            this.dispatchThread.start();
        } else {
            this.dispatchThread = null;
        }
    }

    public boolean isRunning() {
        return this.dispatchThread != null;
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.dispatchThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThrottle(NBThrottle nBThrottle) {
        Object object = this.Q_LOCK;
        synchronized (object) {
            ArrayList<NBThrottle> arrayList = new ArrayList<NBThrottle>(this.THROTTLE);
            arrayList.add(nBThrottle);
            this.THROTTLE = arrayList;
        }
    }

    public void registerAccept(SelectableChannel selectableChannel, AcceptObserver acceptObserver) {
        this.register(selectableChannel, acceptObserver, 16);
    }

    public void registerConnect(SelectableChannel selectableChannel, ConnectObserver connectObserver) {
        this.register(selectableChannel, connectObserver, 8);
    }

    public void registerRead(SelectableChannel selectableChannel, ReadObserver readObserver) {
        this.register(selectableChannel, readObserver, 1);
    }

    public void registerWrite(SelectableChannel selectableChannel, WriteObserver writeObserver) {
        this.register(selectableChannel, writeObserver, 4);
    }

    public void registerReadWrite(SelectableChannel selectableChannel, ReadWriteObserver readWriteObserver) {
        this.register(selectableChannel, readWriteObserver, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver, int n) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.registerImpl(this.selector, selectableChannel, n, iOErrorObserver);
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.REGISTER.add(new RegisterOp(selectableChannel, iOErrorObserver, n));
            }
        }
    }

    public void interestWrite(SelectableChannel selectableChannel, boolean bl) {
        this.interest(selectableChannel, 4, bl);
    }

    public void interestRead(SelectableChannel selectableChannel, boolean bl) {
        this.interest(selectableChannel, 1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(SelectableChannel selectableChannel, int n, boolean bl) {
        block7: {
            try {
                SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
                if (selectionKey == null || !selectionKey.isValid()) break block7;
                Object object = selectableChannel.blockingLock();
                synchronized (object) {
                    if (bl) {
                        selectionKey.interestOps(selectionKey.interestOps() | n);
                    } else {
                        selectionKey.interestOps(selectionKey.interestOps() & ~n);
                    }
                }
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    public void shutdown(Shutdownable shutdownable) {
        shutdownable.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (Thread.currentThread() == this.dispatchThread) {
            runnable.run();
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(runnable);
            }
        }
    }

    public IOErrorObserver attachment(Object object) {
        return ((Attachment)object).attachment;
    }

    private void cancel(SelectionKey selectionKey, Shutdownable shutdownable) {
        selectionKey.cancel();
        if (shutdownable != null) {
            shutdownable.shutdown();
        }
    }

    private void processAccept(SelectionKey selectionKey, AcceptObserver acceptObserver) throws IOException {
        ServerSocketChannel serverSocketChannel;
        SocketChannel socketChannel;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling accept: " + acceptObserver));
        }
        if ((socketChannel = (serverSocketChannel = (ServerSocketChannel)selectionKey.channel()).accept()) == null) {
            return;
        }
        if (socketChannel.isOpen()) {
            socketChannel.configureBlocking(false);
            acceptObserver.handleAccept(socketChannel);
        } else {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)"SocketChannel.close()", (Throwable)iOException);
            }
        }
    }

    private void processConnect(SelectionKey selectionKey, ConnectObserver connectObserver) throws IOException {
        SocketChannel socketChannel;
        boolean bl;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling connect: " + connectObserver));
        }
        if (bl = (socketChannel = (SocketChannel)selectionKey.channel()).finishConnect()) {
            selectionKey.interestOps(0);
            connectObserver.handleConnect();
        } else {
            this.cancel(selectionKey, connectObserver);
        }
    }

    private void registerImpl(Selector selector, SelectableChannel selectableChannel, int n, IOErrorObserver iOErrorObserver) {
        try {
            selectableChannel.register(selector, n, new Attachment(iOErrorObserver));
        }
        catch (IOException iOException) {
            iOErrorObserver.handleIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingItems() {
        Iterator iterator = this.Q_LOCK;
        synchronized (iterator) {
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < this.THROTTLE.size()) {
                ((NBThrottle)this.THROTTLE.get(n)).tick(l);
                ++n;
            }
            this.UNLOCKED.ensureCapacity(this.REGISTER.size() + this.LATER.size());
            this.UNLOCKED.addAll(this.REGISTER);
            this.UNLOCKED.addAll(this.LATER);
            this.REGISTER.clear();
            this.LATER.clear();
        }
        if (!this.UNLOCKED.isEmpty()) {
            iterator = this.UNLOCKED.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                try {
                    if (e instanceof RegisterOp) {
                        RegisterOp registerOp = (RegisterOp)e;
                        this.registerImpl(this.selector, registerOp.channel, registerOp.op, registerOp.handler);
                        continue;
                    }
                    if (!(e instanceof Runnable)) continue;
                    ((Runnable)e).run();
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                    ErrorService.error(throwable);
                }
            }
            this.UNLOCKED.clear();
        }
    }

    private void readyThrottles(Collection collection) {
        List list = this.THROTTLE;
        int n = 0;
        while (n < list.size()) {
            ((NBThrottle)list.get(n)).selectableKeys(collection);
            ++n;
        }
    }

    private void process() throws ProcessingException, SpinningException {
        boolean bl = false;
        long l = -1L;
        int n = 0;
        int n2 = 0;
        while (true) {
            if (!bl || !CommonUtils.isWindows()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.warn((Object)"Selector interrupted", (Throwable)interruptedException);
                }
            }
            this.addPendingItems();
            try {
                if (bl) {
                    l = System.currentTimeMillis();
                }
                this.selector.select(100L);
            }
            catch (NullPointerException nullPointerException) {
                LOG.warn((Object)"npe", (Throwable)nullPointerException);
                continue;
            }
            catch (CancelledKeyException cancelledKeyException) {
                LOG.warn((Object)"cancelled", (Throwable)cancelledKeyException);
                continue;
            }
            catch (IOException iOException) {
                throw new ProcessingException(iOException);
            }
            Set<SelectionKey> set = this.selector.selectedKeys();
            if (set.size() == 0) {
                if (l == -1L) {
                    LOG.warn((Object)"No keys selected, starting spin check.");
                    bl = true;
                    continue;
                }
                if (l + 30L >= System.currentTimeMillis()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Spinning detected, current spins: " + n));
                    }
                    if ((long)n++ <= 5000L) continue;
                    throw new SpinningException();
                }
                bl = false;
                l = -1L;
                n = 0;
                n2 = 0;
                continue;
            }
            if (bl && ++n2 > 5) {
                bl = false;
                n = 0;
                l = -1L;
                n2 = 0;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Selected (" + set.size() + ") keys."));
            }
            this.readyThrottles(set);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                if (!selectionKey.isValid()) continue;
                this.process(selectionKey, selectionKey.attachment(), 65535);
            }
            set.clear();
            ++this.iteration;
        }
    }

    void process(SelectionKey selectionKey, Object object, int n) {
        Attachment attachment = (Attachment)object;
        IOErrorObserver iOErrorObserver = attachment.attachment;
        if (attachment.lastMod == this.iteration) {
            Attachment attachment2 = attachment;
            attachment2.hits = attachment2.hits + 1L;
        } else if (attachment.lastMod < this.iteration) {
            attachment.hits = 0L;
        }
        attachment.lastMod = this.iteration + 1L;
        if (attachment.hits < 10000L) {
            try {
                try {
                    if ((n & 0x10) != 0 && selectionKey.isAcceptable()) {
                        this.processAccept(selectionKey, (AcceptObserver)iOErrorObserver);
                    } else if ((n & 8) != 0 && selectionKey.isConnectable()) {
                        this.processConnect(selectionKey, (ConnectObserver)iOErrorObserver);
                    } else {
                        if ((n & 1) != 0 && selectionKey.isReadable()) {
                            ((ReadObserver)iOErrorObserver).handleRead();
                        }
                        if ((n & 4) != 0 && selectionKey.isWritable()) {
                            ((WriteObserver)iOErrorObserver).handleWrite();
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    LOG.warn((Object)"Ignoring cancelled key", (Throwable)cancelledKeyException);
                }
                catch (IOException iOException) {
                    LOG.warn((Object)"IOX processing", (Throwable)iOException);
                    iOErrorObserver.handleIOException(iOException);
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable, "Unhandled exception while dispatching");
                this.safeCancel(selectionKey, iOErrorObserver);
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Too many hits in a row for: " + iOErrorObserver));
            }
            this.safeCancel(selectionKey, iOErrorObserver);
        }
    }

    private void safeCancel(SelectionKey selectionKey, Shutdownable shutdownable) {
        try {
            this.cancel(selectionKey, shutdownable);
        }
        catch (Throwable throwable) {}
    }

    private void swapSelector() {
        Selector selector = this.selector;
        Set<SelectionKey> set = Collections.EMPTY_SET;
        try {
            if (selector != null) {
                set = selector.keys();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            LOG.warn((Object)"error getting keys", (Throwable)closedSelectorException);
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            LOG.error((Object)"Can't make a new selector!!!", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                SelectableChannel selectableChannel = selectionKey.channel();
                Object object = selectionKey.attachment();
                int n = selectionKey.interestOps();
                try {
                    selectableChannel.register(this.selector, n, object);
                }
                catch (IOException iOException) {
                    ((Attachment)object).attachment.handleIOException(iOException);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                LOG.warn((Object)"key cancelled while swapping", (Throwable)cancelledKeyException);
            }
        }
        try {
            if (selector != null) {
                selector.close();
            }
        }
        catch (IOException iOException) {
            LOG.warn((Object)"error closing old selector", (Throwable)iOException);
        }
    }

    public void run() {
        while (true) {
            try {
                if (this.selector == null) {
                    this.selector = Selector.open();
                }
                this.process();
                continue;
            }
            catch (SpinningException spinningException) {
                LOG.warn((Object)"selector is spinning!", (Throwable)spinningException);
                this.swapSelector();
                continue;
            }
            catch (ProcessingException processingException) {
                LOG.warn((Object)"unknown exception while selecting", (Throwable)processingException);
                this.swapSelector();
                continue;
            }
            catch (IOException iOException) {
                LOG.error((Object)"Unable to create a new Selector!!!", (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Error in Selector!", throwable);
                ErrorService.error(throwable);
                this.swapSelector();
                continue;
            }
            break;
        }
    }

    private static class RegisterOp {
        private final SelectableChannel channel;
        private final IOErrorObserver handler;
        private final int op;

        RegisterOp(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver, int n) {
            this.channel = selectableChannel;
            this.handler = iOErrorObserver;
            this.op = n;
        }
    }

    static class Attachment {
        private final IOErrorObserver attachment;
        private long lastMod;
        private long hits;

        Attachment(IOErrorObserver iOErrorObserver) {
            this.attachment = iOErrorObserver;
        }
    }

    private static class SpinningException
    extends Exception {
    }

    private static class ProcessingException
    extends Exception {
        public ProcessingException() {
        }

        public ProcessingException(Throwable throwable) {
            super(throwable);
        }
    }
}

