/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.util.BitSet;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.Utilities;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class QueryRouteTable {
    public static final byte DEFAULT_INFINITY = 7;
    public static final byte KEYWORD_NO_CHANGE = 0;
    public static final int DEFAULT_TABLE_SIZE = 65536;
    public static final int MAX_PATCH_SIZE = 4096;
    private byte infinity;
    private byte keywordPresent;
    private byte keywordAbsent;
    private BitSet bitTable;
    private QueryRouteTable resizedQRT = null;
    private int bitTableLength;
    private int sequenceNumber;
    private int sequenceSize;
    private int nextPatch;
    private Inflater uncompressor;

    public QueryRouteTable() {
        this(65536);
    }

    public QueryRouteTable(int n) {
        this(n, 7);
    }

    public QueryRouteTable(int n, byte by) {
        this.initialize(n, by);
    }

    private void initialize(int n, byte by) {
        this.bitTableLength = n;
        this.bitTable = new BitSet();
        this.sequenceNumber = -1;
        this.sequenceSize = -1;
        this.nextPatch = 0;
        this.keywordPresent = (byte)(1 - by);
        this.keywordAbsent = (byte)(by - 1);
        this.infinity = by;
    }

    public int getSize() {
        return this.bitTableLength;
    }

    public double getPercentFull() {
        double d = this.bitTable.cardinality();
        return d / (double)this.bitTableLength * 100.0;
    }

    public int getEmptyUnits() {
        return this.bitTable.unusedUnits();
    }

    public int getUnitsInUse() {
        return this.bitTable.getUnitsInUse();
    }

    public boolean contains(QueryRequest queryRequest) {
        int n;
        int n2;
        int n3;
        byte by = Utilities.log2(this.bitTableLength);
        String string = queryRequest.getQuery();
        LimeXMLDocument limeXMLDocument = queryRequest.getRichQuery();
        if (string.length() == 0 && limeXMLDocument == null && !queryRequest.hasQueryUrns()) {
            return false;
        }
        if (queryRequest.hasQueryUrns()) {
            Set set = queryRequest.getQueryUrns();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                URN uRN = (URN)iterator.next();
                int n4 = HashFunction.hash(uRN.toString(), by);
                if (!this.contains(n4)) continue;
                return true;
            }
            return false;
        }
        int n5 = 0;
        while ((n3 = HashFunction.keywordStart(string, n5)) >= 0) {
            n2 = HashFunction.keywordEnd(string, n3);
            n = HashFunction.hash(string, n3, n2, by);
            if (!this.contains(n)) {
                return false;
            }
            n5 = n2 + 1;
        }
        if (limeXMLDocument == null) {
            return true;
        }
        String string2 = limeXMLDocument.getSchemaURI();
        n3 = HashFunction.hash(string2, by);
        if (!this.contains(n3)) {
            return false;
        }
        n2 = 0;
        n = 0;
        Iterator iterator = limeXMLDocument.getKeyWords().iterator();
        while (iterator.hasNext()) {
            int n6;
            String string3 = (String)iterator.next();
            int n7 = 0;
            while ((n6 = HashFunction.keywordStart(string3, n7)) >= 0) {
                int n8 = HashFunction.keywordEnd(string3, n6);
                int n9 = HashFunction.hash(string3, n6, n8, by);
                if (this.contains(n9)) {
                    ++n;
                }
                ++n2;
                n7 = n8 + 1;
            }
        }
        iterator = limeXMLDocument.getKeyWordsIndivisible().iterator();
        while (iterator.hasNext()) {
            n3 = HashFunction.hash((String)iterator.next(), by);
            if (this.contains(n3)) {
                ++n;
            }
            ++n2;
        }
        if (n2 < 3) {
            return n2 == n;
        }
        return (double)((float)n / (float)n2) > 0.67;
    }

    private final boolean contains(int n) {
        return this.bitTable.get(n);
    }

    public void add(String string) {
        this.addBTInternal(string);
    }

    private void addBTInternal(String string) {
        String[] stringArray = HashFunction.keywords(string);
        String[] stringArray2 = HashFunction.getPrefixes(stringArray);
        byte by = Utilities.log2(this.bitTableLength);
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = HashFunction.hash(stringArray2[n], by);
            if (!this.bitTable.get(n2)) {
                this.resizedQRT = null;
                this.bitTable.set(n2);
            }
            ++n;
        }
    }

    public void addIndivisible(String string) {
        int n = HashFunction.hash(string, Utilities.log2(this.bitTableLength));
        if (!this.bitTable.get(n)) {
            this.resizedQRT = null;
            this.bitTable.set(n);
        }
    }

    public void addAll(QueryRouteTable queryRouteTable) {
        this.bitTable.or(queryRouteTable.resize(this.bitTableLength));
    }

    private BitSet resize(int n) {
        if (this.bitTableLength == n) {
            return this.bitTable;
        }
        if (this.resizedQRT != null && this.resizedQRT.bitTableLength == n) {
            return this.resizedQRT.bitTable;
        }
        this.resizedQRT = new QueryRouteTable(n);
        int n2 = this.bitTableLength;
        int n3 = this.resizedQRT.bitTableLength;
        int n4 = this.bitTable.nextSetBit(0);
        while (n4 >= 0) {
            int n5 = (int)((long)n4 * (long)n3 / (long)n2);
            n4 = this.bitTable.nextClearBit(n4 + 1);
            int n6 = (int)(((long)n4 * (long)n3 - 1L) / (long)n2 + 1L);
            this.resizedQRT.bitTable.set(n5, n6);
            n4 = this.bitTable.nextSetBit(n4 + 1);
        }
        return this.resizedQRT.bitTable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QueryRouteTable)) {
            return false;
        }
        QueryRouteTable queryRouteTable = (QueryRouteTable)object;
        if (this.bitTableLength != queryRouteTable.bitTableLength) {
            return false;
        }
        return this.bitTable.equals(queryRouteTable.bitTable);
    }

    public int hashCode() {
        return this.bitTable.hashCode() * 17;
    }

    public String toString() {
        return "QueryRouteTable : " + this.bitTable.toString();
    }

    public void reset(ResetTableMessage resetTableMessage) {
        this.initialize(resetTableMessage.getTableSize(), resetTableMessage.getInfinity());
    }

    public void patch(PatchTableMessage patchTableMessage) throws BadPacketException {
        this.handlePatch(patchTableMessage);
    }

    private void handlePatch(PatchTableMessage patchTableMessage) throws BadPacketException {
        if (this.sequenceSize != -1 && this.sequenceSize != patchTableMessage.getSequenceSize()) {
            throw new BadPacketException("Inconsistent seq size: " + patchTableMessage.getSequenceSize() + " vs. " + this.sequenceSize);
        }
        if (this.sequenceNumber == -1 ? patchTableMessage.getSequenceNumber() != 1 : this.sequenceNumber + 1 != patchTableMessage.getSequenceNumber()) {
            throw new BadPacketException("Inconsistent seq number: " + patchTableMessage.getSequenceNumber() + " vs. " + this.sequenceNumber);
        }
        byte[] byArray = patchTableMessage.getData();
        if (patchTableMessage.getCompressor() == 1) {
            try {
                if (patchTableMessage.getSequenceNumber() == 1) {
                    this.uncompressor = new Inflater();
                }
                Assert.that(this.uncompressor != null, "Null uncompressor.  Sequence: " + patchTableMessage.getSequenceNumber());
                byArray = this.uncompress(byArray);
            }
            catch (IOException iOException) {
                throw new BadPacketException("Couldn't uncompress data: " + iOException);
            }
        } else if (patchTableMessage.getCompressor() != 0) {
            throw new BadPacketException("Unknown compressor");
        }
        if (patchTableMessage.getEntryBits() == 4) {
            byArray = QueryRouteTable.unhalve(byArray);
        } else if (patchTableMessage.getEntryBits() != 8) {
            throw new BadPacketException("Unknown value for entry bits");
        }
        int n = 0;
        while (n < byArray.length) {
            if (this.nextPatch >= this.bitTableLength) {
                throw new BadPacketException("Tried to patch " + this.nextPatch + " on a bitTable of size " + this.bitTableLength);
            }
            if (byArray[n] < 0) {
                this.bitTable.set(this.nextPatch);
                this.resizedQRT = null;
            } else if (byArray[n] > 0) {
                this.bitTable.clear(this.nextPatch);
                this.resizedQRT = null;
            }
            ++this.nextPatch;
            ++n;
        }
        this.bitTable.compact();
        this.sequenceSize = patchTableMessage.getSequenceSize();
        if (patchTableMessage.getSequenceNumber() != patchTableMessage.getSequenceSize()) {
            this.sequenceNumber = patchTableMessage.getSequenceNumber();
        } else {
            this.sequenceNumber = -1;
            this.sequenceSize = -1;
            this.nextPatch = 0;
            if (this.uncompressor != null) {
                this.uncompressor = null;
            }
        }
    }

    public List encode(QueryRouteTable queryRouteTable) {
        return this.encode(queryRouteTable, true);
    }

    public List encode(QueryRouteTable queryRouteTable, boolean bl) {
        byte by;
        byte[] byArray;
        LinkedList<RouteTableMessage> linkedList = new LinkedList<RouteTableMessage>();
        if (queryRouteTable == null) {
            linkedList.add(new ResetTableMessage(this.bitTableLength, this.infinity));
        } else {
            Assert.that(queryRouteTable.bitTableLength == this.bitTableLength, "TODO: can't deal with tables of different lengths");
        }
        byte[] byArray2 = new byte[this.bitTableLength];
        Utilities.fill(byArray2, 0, this.bitTableLength, (byte)0);
        boolean bl2 = false;
        if (queryRouteTable != null) {
            if (!this.bitTable.equals(queryRouteTable.bitTable)) {
                int n;
                BitSet bitSet = (BitSet)this.bitTable.clone();
                bitSet.xor(queryRouteTable.bitTable);
                int by2 = bitSet.nextSetBit(0);
                while (n >= 0) {
                    byArray2[n] = this.bitTable.get(n) ? this.keywordPresent : this.keywordAbsent;
                    bl2 = true;
                    n = bitSet.nextSetBit((int)(n + true));
                }
            }
        } else {
            int n = this.bitTable.nextSetBit(0);
            while (n >= 0) {
                byArray2[n] = this.keywordPresent;
                bl2 = true;
                n = this.bitTable.nextSetBit(n + 1);
            }
        }
        if (!bl2) {
            return linkedList;
        }
        byte by2 = 8;
        if (this.keywordPresent >= -8 && this.keywordAbsent <= 7) {
            by2 = 4;
            byArray2 = QueryRouteTable.halve(byArray2);
        }
        boolean bl3 = false;
        if (bl && (byArray = IOUtils.deflate(byArray2)).length < byArray2.length) {
            byArray2 = byArray;
            by = 1;
        }
        int n = (int)Math.ceil((float)byArray2.length / 4096.0f);
        int n2 = 1;
        int n3 = 0;
        while (n3 < byArray2.length) {
            int n4 = Math.min(n3 + 4096, byArray2.length);
            linkedList.add(new PatchTableMessage((short)n2, (short)n, by, by2, byArray2, n3, n4));
            ++n2;
            n3 += 4096;
        }
        return linkedList;
    }

    private byte[] uncompress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.uncompressor.setInput(byArray);
        try {
            int n;
            byte[] byArray2 = new byte[1024];
            while ((n = this.uncompressor.inflate(byArray2)) != 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad deflate format");
        }
    }

    static byte[] halve(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = (byte)(byArray[2 * n] << 4 | byArray[2 * n + 1] & 0xF);
            ++n;
        }
        return byArray2;
    }

    static byte[] unhalve(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        while (n < byArray.length) {
            byArray2[2 * n] = (byte)(byArray[n] >> 4);
            byArray2[2 * n + 1] = QueryRouteTable.extendNibble((byte)(byArray[n] & 0xF));
            ++n;
        }
        return byArray2;
    }

    static byte extendNibble(byte by) {
        if ((by & 8) != 0) {
            return (byte)(0xF0 | by);
        }
        return by;
    }
}

