/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.settings.Setting;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;

public final class PasswordSetting
extends Setting {
    public static final String MD5 = "MD5";
    private static final String[] ALGORITHMS = new String[]{"MD5"};
    private static final String SEPERATOR = "/";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String algorithm;
    private String value;

    PasswordSetting(Properties properties, Properties properties2, String string, String string2, String string3) {
        this(properties, properties2, string, string2, string3, null);
    }

    PasswordSetting(Properties properties, Properties properties2, String string, String string2, String string3, String string4) {
        super(properties, properties2, string2, PasswordSetting.isEncrypted(string3) ? string3 : PasswordSetting.encrypt(string, string3), string4);
        this.postInitWithAlgorithm(string);
        this.setPrivate(true);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        if (!PasswordSetting.isEncrypted(string)) {
            string = PasswordSetting.encrypt(this.algorithm, string);
        }
        if (!string.startsWith(String.valueOf(this.algorithm) + SEPERATOR)) {
            throw new IllegalArgumentException("Algorithm mismatch");
        }
        return this.value.equalsIgnoreCase(string);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        super.setValue(string);
    }

    protected void loadValue(String string) {
        if (this.algorithm != null && !PasswordSetting.isEncrypted(string)) {
            this.setValue(PasswordSetting.encrypt(this.algorithm, string));
            return;
        }
        this.value = string;
    }

    private void postInitWithAlgorithm(String string) {
        this.algorithm = string;
        if (string != null && !PasswordSetting.isEncrypted(this.value)) {
            this.setValue(PasswordSetting.encrypt(string, this.value));
        }
    }

    private static boolean isEncrypted(String string) {
        int n = 0;
        while (n < ALGORITHMS.length) {
            if (string.startsWith(String.valueOf(ALGORITHMS[n]) + SEPERATOR)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String encrypt(String string, String string2) {
        return PasswordSetting.encrypt(string, "UTF-8", string2);
    }

    private static String encrypt(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray = messageDigest.digest(string3.getBytes(string2));
            return String.valueOf(string) + SEPERATOR + PasswordSetting.toHexString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorService.error(noSuchAlgorithmException);
            return null;
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(HEX[byArray[n] >> 4 & 0xF]).append(HEX[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

