/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FixedSizeExpiringSet
implements Set,
Collection {
    private static final int DEFAULT_SIZE = 50;
    private static final long DEFAULT_EXPIRE_TIME = 600000L;
    private final int _maxSize;
    private final long _expireTime;
    private Map _map;

    public FixedSizeExpiringSet() {
        this(50);
    }

    public FixedSizeExpiringSet(int n) {
        this(n, 600000L);
    }

    public FixedSizeExpiringSet(int n, long l) {
        this._maxSize = n;
        this._expireTime = l;
        this._map = new HashMap();
    }

    public int size() {
        this.expire(false);
        return this._map.size();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public boolean contains(Object object) {
        Long l = (Long)this._map.get(object);
        if (l == null) {
            return false;
        }
        if (l < System.currentTimeMillis()) {
            this._map.remove(object);
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        this.expire(false);
        return this._map.keySet().iterator();
    }

    public Object[] toArray() {
        this.expire(false);
        return this._map.keySet().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.expire(false);
        return this._map.keySet().toArray(objectArray);
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        this.expire(this.size() >= this._maxSize);
        if (this._map.containsKey(object)) {
            return false;
        }
        this._map.put(object, new Long(System.currentTimeMillis() + this._expireTime));
        return true;
    }

    public boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    public boolean containsAll(Collection collection) {
        return this._map.keySet().containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        int n = 0;
        Iterator iterator = collection.iterator();
        while (n < this._maxSize && iterator.hasNext()) {
            this.add(iterator.next());
            ++n;
        }
        return true;
    }

    public boolean retainAll(Collection collection) {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (collection.contains(k)) {
                hashMap.put(k, this._map.get(k));
                continue;
            }
            bl = true;
        }
        if (bl) {
            this._map = hashMap;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    public void clear() {
        this._map.clear();
    }

    private void expire(boolean bl) {
        if (this._map.size() == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = Long.MAX_VALUE;
        Object var6_4 = null;
        HashSet hashSet = new HashSet();
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Long l3 = (Long)this._map.get(k);
            long l4 = l3;
            if (l4 < l) {
                hashSet.add(k);
                bl = false;
                continue;
            }
            if (!bl || l4 >= l2) continue;
            l2 = l4;
            var6_4 = k;
        }
        if (hashSet.size() > 0) {
            this.removeAll((Collection)hashSet);
        }
        if (bl) {
            this.remove(var6_4);
        }
    }
}

