/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

import com.bitzi.util.Base32;
import com.bitzi.util.Tiger;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private static final boolean USE_CRYPTIX;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private List nodes = new ArrayList();

    static {
        boolean bl = USE_CRYPTIX = CommonUtils.isJava14OrLater() && CommonUtils.isMacOSX() && CommonUtils.isJaguarOrAbove() && !CommonUtils.isPantherOrAbove();
        if (USE_CRYPTIX) {
            try {
                Class<?> clazz = Class.forName("cryptix.jce.provider.CryptixCrypto");
                Object obj = clazz.newInstance();
                Security.addProvider((Provider)obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorService.error(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorService.error(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                ErrorService.error(instantiationException);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                ErrorService.error(exceptionInInitializerError);
            }
            catch (SecurityException securityException) {
                ErrorService.error(securityException);
            }
            catch (ClassCastException classCastException) {
                ErrorService.error(classCastException);
            }
        }
    }

    public TigerTree() {
        super("tigertree");
        if (USE_CRYPTIX) {
            try {
                this.tiger = MessageDigest.getInstance("Tiger", "CryptixCrypto");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.tiger = new Tiger();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                this.tiger = new Tiger();
            }
        } else {
            this.tiger = new Tiger();
        }
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = by;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        this.byteCount += (long)n2;
        while (n2 >= (n3 = 1024 - this.bufferOffset)) {
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n3);
            this.bufferOffset += n3;
            this.blockUpdate();
            n2 -= n3;
            n += n3;
            this.bufferOffset = 0;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n2);
        this.bufferOffset += n2;
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[24];
        try {
            this.engineDigest(byArray, 0, 24);
        }
        catch (DigestException digestException) {
            return null;
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        while (this.nodes.size() > 1) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = (byte[])iterator.next();
                if (iterator.hasNext()) {
                    byte[] byArray3 = (byte[])iterator.next();
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(byArray2, 0, byArray2.length);
                    this.tiger.update(byArray3, 0, byArray3.length);
                    arrayList.add((Object)this.tiger.digest());
                    continue;
                }
                arrayList.add((Object)byArray2);
            }
            this.nodes = arrayList;
        }
        System.arraycopy(this.nodes.get(0), 0, byArray, n, 24);
        this.engineReset();
        return 24;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new ArrayList();
        this.tiger.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 & this.nodes.size() > 0) {
            return;
        }
        this.nodes.add((Object)this.tiger.digest());
    }

    public static void main(String[] stringArray) throws IOException, NoSuchAlgorithmException {
        if (stringArray.length < 1) {
            System.out.println("You must supply a filename.");
            return;
        }
        TigerTree tigerTree = new TigerTree();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            FileInputStream fileInputStream = new FileInputStream(stringArray[n]);
            byte[] byArray = new byte[1024];
            while ((n2 = fileInputStream.read(byArray)) > -1) {
                tigerTree.update(byArray, 0, n2);
            }
            fileInputStream.close();
            byte[] byArray2 = tigerTree.digest();
            String string = new BigInteger(1, byArray2).toString(16);
            while (string.length() < 48) {
                string = "0" + string;
            }
            System.out.println("hex:" + string);
            System.out.println("b32:" + Base32.encode(byArray2));
            tigerTree.reset();
            ++n;
        }
    }
}

