/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;

public final class PushManager {
    private static final int PUSH_INVALIDATE_TIME = 300;
    private static final int CONNECT_TIMEOUT = 10000;
    private List _failedPushes = new LinkedList();
    private List _attemptingPushes = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptPushUpload(final String string, final String string2, final int n, final int n2, final String string3, final boolean bl) {
        if (string == null) {
            throw new NullPointerException("null file");
        }
        if (string2 == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (string3 == null) {
            throw new NullPointerException("null guid");
        }
        FileManager fileManager = RouterService.getFileManager();
        FileDesc fileDesc = null;
        if (fileManager.isValidIndex(n2)) {
            fileDesc = fileManager.get(n2);
        }
        if (fileDesc == null) {
            return;
        }
        if (!string.equals(fileDesc.getName())) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.clearFailedPushes();
            if (!(bl || this.testAttemptingPush(string2, n2) && this.testFailedPush(string2, n2))) {
                return;
            }
            this.insertAttemptingPush(string2, n2);
        }
        object = new ManagedThread("PushUploadThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void managedRun() {
                Socket socket;
                block30: {
                    socket = null;
                    try {
                        try {
                            socket = Sockets.connect(string2, n, 10000);
                            OutputStream outputStream = socket.getOutputStream();
                            String string4 = "GIV " + n2 + ":" + string3 + "/" + string + "\n\n";
                            outputStream.write(string4.getBytes());
                            outputStream.flush();
                            String string22 = IOUtils.readWord(socket.getInputStream(), 4);
                            if (string22.equals("GET")) {
                                UploadStat.PUSHED_GET.incrementStat();
                                RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, socket, bl);
                                break block30;
                            }
                            if (string22.equals("HEAD")) {
                                UploadStat.PUSHED_HEAD.incrementStat();
                                RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, socket, bl);
                                break block30;
                            }
                            UploadStat.PUSHED_UNKNOWN.incrementStat();
                            throw new IOException();
                        }
                        catch (IOException iOException) {
                            UploadStat.PUSH_FAILED.incrementStat();
                            1 var2_3 = this;
                            synchronized (var2_3) {
                                PushManager.this.insertFailedPush(string2, n2);
                            }
                        }
                        catch (Throwable throwable) {
                            ErrorService.error(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            try {
                                socket.getInputStream().close();
                            }
                            catch (IOException iOException) {}
                            try {
                                socket.getOutputStream().close();
                            }
                            catch (IOException iOException) {}
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        1 var6_8 = this;
                        synchronized (var6_8) {
                            PushManager.this.removeAttemptingPush(string2, n2);
                        }
                        throw throwable;
                    }
                }
                if (socket != null) {
                    try {
                        socket.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        socket.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                1 var6_9 = this;
                synchronized (var6_9) {
                    PushManager.this.removeAttemptingPush(string2, n2);
                }
            }
        };
        ((Thread)object).start();
    }

    private synchronized void insertFailedPush(String string, int n) {
        this._failedPushes.add((Object)new PushedFile(string, n));
    }

    private synchronized boolean testFailedPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._failedPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            return false;
        }
        return true;
    }

    private synchronized void insertAttemptingPush(String string, int n) {
        this._attemptingPushes.add((Object)new PushedFile(string, n));
    }

    private synchronized boolean testAttemptingPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._attemptingPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            return false;
        }
        return true;
    }

    private synchronized void removeAttemptingPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._attemptingPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            iterator.remove();
        }
    }

    private synchronized void clearFailedPushes() {
        Date date = new Date();
        date.setTime(date.getTime() - 300000L);
        Iterator iterator = this._failedPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile = (PushedFile)iterator.next();
            if (!pushedFile.before(date)) continue;
            iterator.remove();
        }
    }

    private static class PushedFile {
        private final String _host;
        private final int _index;
        private final Date _time;

        public PushedFile(String string, int n) {
            this._host = string;
            this._index = n;
            this._time = new Date();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PushedFile)) {
                return false;
            }
            PushedFile pushedFile = (PushedFile)object;
            return this._index == pushedFile._index && this._host.equals(pushedFile._host);
        }

        public boolean before(Date date) {
            return this._time.before(date);
        }
    }
}

