/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.List;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest queryRequest) {
        this.record(queryRequest, null);
    }

    public synchronized void record(QueryRequest queryRequest, MediaType mediaType) {
        byte[] byArray = queryRequest.getGUID();
        this.mapper.put(new GUID(byArray), new RequestData(queryRequest.getQuery(), queryRequest.getRichQuery(), mediaType));
    }

    public static int score(String string, LimeXMLDocument limeXMLDocument, RemoteFileDesc remoteFileDesc) {
        return ResponseVerifier.score(ResponseVerifier.getSearchTerms(string, limeXMLDocument), remoteFileDesc.getFileName());
    }

    private static int score(String[] stringArray, String string) {
        int n = 0;
        int n2 = stringArray.length;
        if (n2 == 0) {
            return 100;
        }
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (StringUtils.contains(string, string2, true)) {
                ++n;
            }
            ++n3;
        }
        return (int)((float)n * 100.0f / (float)n2);
    }

    public boolean matchesType(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.type == null) {
            return true;
        }
        String string = response.getName();
        return requestData.type.matches(string);
    }

    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(String.valueOf(requestData.query) + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static String[] getSearchTerms(String string, LimeXMLDocument limeXMLDocument) {
        String[] stringArray = null;
        HashSet hashSet = new HashSet();
        stringArray = StringUtils.split(string.toLowerCase(), DELIMITERS);
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add((Object)stringArray[n]);
            ++n;
        }
        List list = null;
        if (limeXMLDocument != null) {
            list = limeXMLDocument.getKeyWords();
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                String string2 = (String)list.remove(0);
                hashSet.add((Object)string2.toLowerCase());
                ++n3;
            }
        }
        return (String[])hashSet.toArray((Object[])new String[hashSet.size()]);
    }

    private static class RequestData {
        String query;
        LimeXMLDocument richQuery;
        String[] queryWords;
        MediaType type;

        RequestData(String string, MediaType mediaType) {
            this(string, null, mediaType);
        }

        RequestData(String string, LimeXMLDocument limeXMLDocument, MediaType mediaType) {
            this.query = string;
            this.richQuery = limeXMLDocument;
            this.queryWords = ResponseVerifier.getSearchTerms(string, limeXMLDocument);
            this.type = mediaType;
        }

        public boolean xmlQuery() {
            return this.richQuery != null;
        }
    }
}

