/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class QueryReply
extends Message
implements Serializable {
    public static final int XML_MAX_SIZE = 32768;
    public static final int COMMON_PAYLOAD_LEN = 4;
    private byte[] _payload;
    private volatile boolean _parsed = false;
    private volatile Response[] _responses = null;
    private volatile String _vendor = null;
    private volatile int _pushFlag = -1;
    private volatile int _busyFlag = -1;
    private volatile int _uploadedFlag = -1;
    private volatile int _measuredSpeedFlag = -1;
    private volatile int _supportsChat = -1;
    private volatile int _supportsBrowseHost = 0;
    private volatile int _replyToMulticast = 0;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNDEFINED = -1;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    private byte[] _xmlBytes = new byte[0];
    private byte[] _address = new byte[4];
    private Set _proxies;
    private boolean _browseHostReply;
    private HostData _hostData;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    public static final boolean debugOn = false;

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, bl, DataUtils.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, true, bl, bl2, bl3, bl4, bl5, true, bl6, DataUtils.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, bl, bl2, bl3, bl4, bl5, bl6, DataUtils.EMPTY_SET);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Set set) throws IllegalArgumentException {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, set);
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException("XML bytes too big: " + byArray4.length);
        }
        this._xmlBytes = byArray4;
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, (byte)-127, by, by2, byArray2.length);
        this._payload = byArray2;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.REPLY_INVALID_PORT.incrementStat();
            }
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.REPLY_INVALID_SPEED.incrementStat();
            }
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
        if (!NetworkUtils.isValidAddress(this.getIPBytes())) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.REPLY_INVALID_ADDRESS.incrementStat();
            }
            throw new BadPacketException("invalid address");
        }
    }

    public QueryReply(byte[] byArray, QueryReply queryReply) {
        super(byArray, (byte)-127, queryReply.getTTL(), queryReply.getHops(), queryReply.getLength());
        this._payload = queryReply._payload;
        this.setAddress();
    }

    private QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Set set) {
        super(byArray, (byte)-127, by, (byte)0, 0, 16);
        if (byArray4.length > 32768) {
            return;
        }
        int n2 = responseArray.length;
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray2.length);
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(byArray2));
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + l);
        }
        if (n2 >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n2);
        }
        this._proxies = set;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(n2);
            ByteOrder.short2leb((short)n, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            ByteOrder.int2leb((int)l, byteArrayOutputStream);
            int n3 = n2;
            while (n3 > 0) {
                Response response = responseArray[n2 - n3];
                response.writeToStream(byteArrayOutputStream);
                --n3;
            }
            if (bl) {
                byteArrayOutputStream.write(76);
                byteArrayOutputStream.write(73);
                byteArrayOutputStream.write(77);
                byteArrayOutputStream.write(69);
                byteArrayOutputStream.write(4);
                n3 = _ggepUtil.getQRGGEP(false, false, DataUtils.EMPTY_SET).length;
                boolean bl9 = this._proxies != null && this._proxies.size() > 0;
                byte by2 = (byte)((bl2 && !bl8 ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte by3 = (byte)(1 | (bl3 && !bl8 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 || bl8 ? 16 : 0) | (bl7 || bl8 || bl9 ? 32 : (n3 > 0 ? 32 : 0)));
                byteArrayOutputStream.write(by2);
                byteArrayOutputStream.write(by3);
                int n4 = byArray4.length + 1;
                if (n4 > 32768) {
                    n4 = 32768;
                }
                ByteOrder.short2leb((short)n4, byteArrayOutputStream);
                int n5 = bl6 ? 1 : 0;
                byteArrayOutputStream.write(n5);
                byte[] byArray5 = _ggepUtil.getQRGGEP(bl7, bl8, this._proxies);
                byteArrayOutputStream.write(byArray5, 0, byArray5.length);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray3, 0, 16);
            this._payload = byteArrayOutputStream.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.setAddress();
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    public void setGUID(GUID gUID) {
        super.setGUID(gUID);
    }

    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._payload);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
        }
    }

    public void setBrowseHostReply(boolean bl) {
        this._browseHostReply = bl;
    }

    public boolean isBrowseHostReply() {
        return this._browseHostReply;
    }

    public byte[] getXMLBytes() {
        this.parseResults();
        return this._xmlBytes;
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this._payload[0]);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this._payload, 1));
    }

    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    public byte[] getIPBytes() {
        return this._address;
    }

    public long getSpeed() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this._payload, 7));
    }

    public Response[] getResultsArray() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException();
        }
        return this._responses;
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException();
        }
        List list = Arrays.asList((Object[])this._responses);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException("results are null");
        }
        List list = Arrays.asList((Object[])this._responses);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        if (this._vendor == null) {
            throw new BadPacketException();
        }
        return this._vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._pushFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this._pushFlag);
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._busyFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this._pushFlag);
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._uploadedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this._pushFlag);
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._measuredSpeedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this._pushFlag);
        return false;
    }

    public boolean getSupportsChat() throws BadPacketException {
        this.parseResults();
        switch (this._supportsChat) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsChat: " + this._supportsChat);
        return false;
    }

    public boolean getSupportsBrowseHost() throws BadPacketException {
        this.parseResults();
        switch (this._supportsBrowseHost) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsBrowseHost: " + this._supportsBrowseHost);
        return false;
    }

    public boolean isReplyToMulticastQuery() throws BadPacketException {
        this.parseResults();
        switch (this._replyToMulticast) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for replyToMulticast: " + this._replyToMulticast);
        return false;
    }

    public Set getPushProxies() {
        this.parseResults();
        return this._proxies;
    }

    public HostData getHostData() throws BadPacketException {
        this.parseResults();
        if (this._hostData == null) {
            throw new BadPacketException();
        }
        return this._hostData;
    }

    private void parseResults() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        this.parseResults2();
    }

    private void parseResults2() {
        Object object;
        int n = 11;
        int n2 = this.getResultCount();
        Response[] responseArray = new Response[n2];
        try {
            object = new ByteArrayInputStream(this._payload, n, this._payload.length - n);
            while (n2 > 0) {
                Response response;
                responseArray[responseArray.length - n2] = response = Response.createFromStream((InputStream)object);
                n += response.getLength();
                --n2;
            }
            this._responses = responseArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        try {
            int n3;
            int n4;
            int n5;
            if (n >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            object = null;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            int n11 = -1;
            int n12 = 0;
            Set set = null;
            try {
                object = new String(this._payload, n, 4, "ISO-8859-1");
                Assert.that(((String)object).length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int n13 = ByteOrder.ubyte2int(this._payload[n += 4]);
            if (n13 <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++n + n13 > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            if (n13 > 1) {
                n5 = this._payload[n];
                n4 = this._payload[n + 1];
                if ((n4 & 1) != 0) {
                    int n14 = n6 = (n5 & 1) == 1 ? 1 : 0;
                }
                if ((n5 & 4) != 0) {
                    int n15 = n7 = (n4 & 4) != 0 ? 1 : 0;
                }
                if ((n5 & 8) != 0) {
                    int n16 = n8 = (n4 & 8) != 0 ? 1 : 0;
                }
                if ((n5 & 0x10) != 0) {
                    int n17 = n9 = (n4 & 0x10) != 0 ? 1 : 0;
                }
                if ((n5 & 0x20) != 0 && (n4 & 0x20) != 0) {
                    n3 = n + 2;
                    while (this._payload[n3] != -61 && n3 < this._payload.length) {
                        ++n3;
                    }
                    GGEP[] gGEPArray = null;
                    try {
                        gGEPArray = GGEP.read(this._payload, n3);
                        if (_ggepUtil.allowsBrowseHost(gGEPArray)) {
                            n11 = 1;
                        }
                        n12 = _ggepUtil.replyToMulticastQuery(gGEPArray) ? 1 : 0;
                        set = _ggepUtil.getPushProxies(gGEPArray);
                    }
                    catch (BadGGEPBlockException badGGEPBlockException) {}
                }
                n += 2;
            }
            if (n13 > 2) {
                int n18;
                if ((n18 = (n5 = (n3 = ByteOrder.ubyte2int(this._payload[n++]))) | (n4 = (n3 = ByteOrder.ubyte2int(this._payload[n++])) << 8)) > 1) {
                    int n19 = this._payload.length - 16 - n18;
                    this._xmlBytes = new byte[n18 - 1];
                    System.arraycopy(this._payload, n19, this._xmlBytes, 0, n18 - 1);
                } else {
                    this._xmlBytes = DataUtils.EMPTY_BYTE_ARRAY;
                }
            }
            if ((n5 = this._payload.length - n) > 0 && (((String)object).equals("LIME") || ((String)object).equals("RAZA"))) {
                n4 = this._payload[n];
                int n20 = n10 = (n4 & 1) != 0 ? 1 : 0;
            }
            if (n > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(object != null);
            this._vendor = ((String)object).toUpperCase(Locale.US);
            this._pushFlag = n6;
            this._busyFlag = n7;
            this._uploadedFlag = n8;
            this._measuredSpeedFlag = n9;
            this._supportsChat = n10;
            this._supportsBrowseHost = n11;
            this._replyToMulticast = n12;
            this._proxies = set == null ? DataUtils.EMPTY_SET : set;
            this._hostData = new HostData(this);
            QueryReply.debug("QR.parseResults2(): returning w/o exception.");
        }
        catch (BadPacketException badPacketException) {
            QueryReply.debug("QR.parseResults2(): bpe = " + badPacketException);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            QueryReply.debug("QR.parseResults2(): index exception = " + indexOutOfBoundsException);
            return;
        }
    }

    public byte[] getClientGUID() {
        byte[] byArray = new byte[16];
        int n = super.getLength();
        System.arraycopy(this._payload, n - 16, byArray, 0, 16);
        return byArray;
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    public int calculateQualityOfService(boolean bl) {
        int n;
        boolean bl2;
        int n2;
        try {
            n2 = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException badPacketException) {
            n2 = 0;
        }
        try {
            bl2 = this.isReplyToMulticastQuery();
        }
        catch (BadPacketException badPacketException) {
            bl2 = false;
        }
        if (bl2) {
            bl = false;
            n = -1;
        } else if (NetworkUtils.isPrivateAddress(this.getIPBytes())) {
            n = 1;
        } else {
            try {
                n = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException badPacketException) {
                n = 0;
            }
        }
        boolean bl3 = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            bl3 = true;
        }
        if (Arrays.equals((byte[])this._address, (byte[])RouterService.getAddress())) {
            return 3;
        }
        if (bl2) {
            return 4;
        }
        if (bl && n == 1) {
            return -1;
        }
        if (n2 == 0 || n == 0) {
            return 0;
        }
        if (n2 == 1) {
            Assert.that(n == -1 || !bl);
            if (n == 1) {
                return 0;
            }
            return 1;
        }
        if (n2 == -1) {
            Assert.that(n == -1 || !bl);
            if (n == 1 && !bl3) {
                return 2;
            }
            return 3;
        }
        Assert.that(false, "Unexpected case!");
        return -1;
    }

    public static boolean isFirewalledQuality(int n) {
        return n == 0 || n == 2;
    }

    public void recordDrop() {
        if (Message.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
        }
    }

    public static void debug(String string) {
    }

    public static void debug(Exception exception) {
    }

    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _comboGGEP;

        public GGEPUtil() {
            GGEP gGEP;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP = new GGEP(false);
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._standardGGEP = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("BH");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._bhGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._bhGGEP != null);
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("MCAST");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._mcGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._mcGGEP != null);
            byteArrayOutputStream.reset();
            try {
                gGEP = new GGEP(false);
                gGEP.put("MCAST");
                gGEP.put("BH");
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            this._comboGGEP = byteArrayOutputStream.toByteArray();
            Assert.that(this._comboGGEP != null);
        }

        public byte[] getQRGGEP(boolean bl, boolean bl2, Set set) {
            byte[] byArray = this._standardGGEP;
            if (set != null && set.size() > 0) {
                GGEP gGEP = new GGEP();
                if (bl) {
                    gGEP.put("BH");
                }
                if (bl2) {
                    gGEP.put("MCAST");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && n < 4) {
                    PushProxyInterface pushProxyInterface = (PushProxyInterface)iterator.next();
                    String string = pushProxyInterface.getPushProxyAddress().getHostAddress();
                    int n2 = pushProxyInterface.getPushProxyPort();
                    try {
                        IPPortCombo iPPortCombo = new IPPortCombo(string, n2);
                        byteArrayOutputStream.write(iPPortCombo.toBytes());
                        ++n;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (IOException iOException) {
                        ErrorService.error(iOException);
                    }
                }
                try {
                    if (n > 0) {
                        gGEP.put("PUSH", byteArrayOutputStream.toByteArray());
                    }
                    byteArrayOutputStream.reset();
                    gGEP.write(byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            } else if (bl && bl2) {
                byArray = this._comboGGEP;
            } else if (bl) {
                byArray = this._bhGGEP;
            } else if (bl2) {
                byArray = this._mcGGEP;
            }
            return byArray;
        }

        public boolean allowsBrowseHost(GGEP[] gGEPArray) {
            boolean bl = false;
            int n = 0;
            while (gGEPArray != null && n < gGEPArray.length && !bl) {
                Set set = gGEPArray[n].getHeaders();
                bl = set.contains((Object)"BH");
                ++n;
            }
            return bl;
        }

        public boolean replyToMulticastQuery(GGEP[] gGEPArray) {
            boolean bl = false;
            int n = 0;
            while (gGEPArray != null && n < gGEPArray.length && !bl) {
                Set set = gGEPArray[n].getHeaders();
                bl = set.contains((Object)"MCAST");
                ++n;
            }
            return bl;
        }

        public Set getPushProxies(GGEP[] gGEPArray) {
            HashSet hashSet = new HashSet();
            int n = 0;
            while (gGEPArray != null && n < gGEPArray.length) {
                block7: {
                    Set set = gGEPArray[n].getHeaders();
                    if (set.contains((Object)"PUSH")) {
                        byte[] byArray = null;
                        try {
                            byArray = gGEPArray[n].getBytes("PUSH");
                        }
                        catch (BadGGEPPropertyException badGGEPPropertyException) {
                            break block7;
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        while (byteArrayInputStream.available() > 0) {
                            byte[] byArray2 = new byte[6];
                            if (byteArrayInputStream.read(byArray2, 0, byArray2.length) != byArray2.length) continue;
                            try {
                                hashSet.add((Object)new PushProxyContainer(byArray2));
                            }
                            catch (BadPacketException badPacketException) {}
                        }
                    }
                }
                ++n;
            }
            return hashSet;
        }
    }

    public static class PushProxyContainer
    implements PushProxyInterface {
        IPPortCombo _combo;

        public PushProxyContainer(String string, int n) throws UnknownHostException {
            this._combo = new IPPortCombo(string, n);
        }

        public PushProxyContainer(byte[] byArray) throws BadPacketException {
            this._combo = IPPortCombo.getCombo(byArray);
        }

        public int getPushProxyPort() {
            return this._combo.getPort();
        }

        public InetAddress getPushProxyAddress() {
            return this._combo.getInetAddress();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PushProxyContainer) {
                PushProxyContainer pushProxyContainer = (PushProxyContainer)object;
                return this._combo.equals(pushProxyContainer._combo);
            }
            return false;
        }

        public int hashCode() {
            return this._combo.hashCode() * 17;
        }
    }

    public static class IPPortCombo
    implements IpPort {
        private int _port;
        private InetAddress _addr;
        public static final String DELIM = ":";

        public static IPPortCombo getCombo(byte[] byArray) throws BadPacketException {
            return new IPPortCombo(byArray);
        }

        private IPPortCombo(byte[] byArray) throws BadPacketException {
            if (byArray.length != 6) {
                throw new BadPacketException("Weird Input");
            }
            String string = NetworkUtils.ip2string(byArray, 0);
            int n = ByteOrder.ubytes2int(ByteOrder.leb2short(byArray, 4));
            if (!NetworkUtils.isValidPort(n)) {
                throw new BadPacketException("Bad Port: " + n);
            }
            this._port = n;
            try {
                this._addr = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new BadPacketException("bad host.");
            }
            if (!NetworkUtils.isValidAddress(this._addr)) {
                throw new BadPacketException("invalid addr: " + this._addr);
            }
        }

        public IPPortCombo(String string, int n) throws UnknownHostException, IllegalArgumentException {
            if (!NetworkUtils.isValidPort(n)) {
                throw new IllegalArgumentException("Bad Port: " + n);
            }
            this._port = n;
            this._addr = InetAddress.getByName(string);
            if (!NetworkUtils.isValidAddress(this._addr)) {
                throw new IllegalArgumentException("invalid addr: " + this._addr);
            }
        }

        public int getPort() {
            return this._port;
        }

        public InetAddress getInetAddress() {
            return this._addr;
        }

        public String getAddress() {
            return this._addr.getHostAddress();
        }

        public byte[] toBytes() {
            byte[] byArray = new byte[6];
            int n = 0;
            while (n < 4) {
                byArray[n] = this._addr.getAddress()[n];
                ++n;
            }
            ByteOrder.short2leb((short)this._port, byArray, 4);
            return byArray;
        }

        public boolean equals(Object object) {
            if (object instanceof IPPortCombo) {
                IPPortCombo iPPortCombo = (IPPortCombo)object;
                return this._addr.equals(iPPortCombo._addr) && this._port == iPPortCombo._port;
            }
            return false;
        }

        public int hashCode() {
            return this._addr.hashCode() * this._port;
        }
    }
}

