/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.statistics.BasicStatistic;
import com.limegroup.gnutella.statistics.Statistic;

public class OutOfBandThroughputStat
extends BasicStatistic {
    public static final int MIN_SAMPLE_SIZE = 500;
    public static final int MIN_SUCCESS_RATE = 60;
    public static final int PROXY_SUCCESS_RATE = 80;
    public static final Statistic RESPONSES_REQUESTED = new OutOfBandThroughputStat();
    public static final Statistic RESPONSES_RECEIVED = new OutOfBandThroughputStat();
    public static final Statistic RESPONSES_BYPASSED = new OutOfBandThroughputStat();
    public static final Statistic OOB_QUERIES_SENT = new OutOfBandThroughputStat();

    private OutOfBandThroughputStat() {
    }

    public static double getSuccessRate() {
        double d = RESPONSES_REQUESTED.getTotal();
        double d2 = RESPONSES_RECEIVED.getTotal();
        return d2 / d * 100.0;
    }

    public static boolean isSuccessRateGood() {
        if (RESPONSES_REQUESTED.getTotal() < 500.0) {
            return true;
        }
        return OutOfBandThroughputStat.getSuccessRate() > 60.0;
    }

    public static boolean isSuccessRateGreat() {
        if (RESPONSES_REQUESTED.getTotal() < 500.0) {
            return true;
        }
        return OutOfBandThroughputStat.getSuccessRate() > 80.0;
    }

    public static boolean isOOBEffectiveForProxy() {
        return !(OOB_QUERIES_SENT.getTotal() > 40.0) || RESPONSES_REQUESTED.getTotal() != 0.0;
    }

    public static boolean isOOBEffectiveForMe() {
        return !(OOB_QUERIES_SENT.getTotal() > 20.0) || RESPONSES_REQUESTED.getTotal() != 0.0;
    }
}

