/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;

public class LimitReachedUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();

    public LimitReachedUploadState(HTTPUploader hTTPUploader) {
        this.UPLOADER = hTTPUploader;
        this.FILE_DESC = hTTPUploader.getFileDesc();
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: text/plain\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: " + ERROR_MESSAGE.length + "\r\n";
        outputStream.write(string.getBytes());
        if (this.FILE_DESC != null) {
            URN uRN = this.FILE_DESC.getSHA1Urn();
            if (uRN != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, outputStream);
                Set set = this.UPLOADER.getNextSetOfAltsToSend();
                if (set.size() > 0) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)set), outputStream);
                }
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, set.size() == 0 ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER, outputStream);
                outputStream.write(string.getBytes());
                if (this.FILE_DESC instanceof IncompleteFileDesc) {
                    HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), outputStream);
                }
            } else {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, NO_ALT_LOCS_RETRY_AFTER, outputStream);
            }
        }
        HTTPUtils.writeHeader(HTTPHeaderName.CONNECTION, ConstantHTTPHeaderValue.CLOSE_VALUE, outputStream);
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        outputStream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }
}

