/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collection;
import java.io.IOException;
import java.io.OutputStream;

public class UnavailableRangeUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    private static final String INACTIVE_RETRY_AFTER = "3600";

    public UnavailableRangeUploadState(HTTPUploader hTTPUploader) {
        this.UPLOADER = hTTPUploader;
        this.FILE_DESC = this.UPLOADER.getFileDesc();
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        String string = "HTTP/1.1 416 Requested Range Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: text/plain\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: 0\r\n";
        outputStream.write(string.getBytes());
        if (this.FILE_DESC != null) {
            Object object;
            URN uRN = this.FILE_DESC.getSHA1Urn();
            if (uRN != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, outputStream);
                object = this.UPLOADER.getNextSetOfAltsToSend();
                if (object.size() > 0) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)object), outputStream);
                }
            }
            if (this.FILE_DESC instanceof IncompleteFileDesc) {
                object = (IncompleteFileDesc)this.FILE_DESC;
                HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)object, outputStream);
                if (!((IncompleteFileDesc)object).isActivelyDownloading()) {
                    HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, INACTIVE_RETRY_AFTER, outputStream);
                }
            }
        }
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

