/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.SystemUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class FileUtils {
    private static final Set UNWRITEABLE = Collections.synchronizedSet((Set)new HashSet());

    public static void writeMap(String string, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(map);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    public static Map readMap(String string) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            Map map = (Map)objectInputStream.readObject();
            return map;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    public static File[] listFiles(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public static File[] listFiles(File file, FilenameFilter filenameFilter) {
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public static File getParentFile(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        try {
            return FileUtils.getCanonicalFile(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File getCanonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static boolean setWriteable(File file) {
        String string;
        if (!file.exists()) {
            return true;
        }
        if (file.canWrite()) {
            if (CommonUtils.isWindows()) {
                return true;
            }
            if (!file.isDirectory()) {
                return true;
            }
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        if (UNWRITEABLE.contains((Object)string)) {
            return false;
        }
        String[] stringArray = null;
        if (CommonUtils.isWindows()) {
            SystemUtils.setWriteable(string);
        } else {
            stringArray = CommonUtils.isMacClassic() ? (String[])null : (CommonUtils.isOS2() ? (String[])null : (file.isDirectory() ? new String[]{"chmod", "u+w+x", string} : new String[]{"chmod", "u+w", string}));
        }
        if (stringArray != null) {
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!file.canWrite()) {
            UNWRITEABLE.add((Object)string);
            return false;
        }
        return true;
    }

    public static void touch(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileOutputStream != null) {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
    }
}

