/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class PushProxyAcknowledgement
extends VendorMessage {
    public static final int VERSION = 2;
    private final InetAddress _addr;
    private final int _port;

    PushProxyAcknowledgement(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 22, n, byArray2);
        if (this.getVersion() == 1) {
            throw new BadPacketException("DEPRECATED VERSION");
        }
        if (this.getVersion() > 2) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 6) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + byArray2.length);
        }
        QueryReply.IPPortCombo iPPortCombo = QueryReply.IPPortCombo.getCombo(this.getPayload());
        this._addr = iPPortCombo.getInetAddress();
        this._port = iPPortCombo.getPort();
    }

    public PushProxyAcknowledgement(InetAddress inetAddress, int n) {
        super(F_LIME_VENDOR_ID, 22, 2, PushProxyAcknowledgement.derivePayload(inetAddress, n));
        this._addr = inetAddress;
        this._port = n;
    }

    public PushProxyAcknowledgement(InetAddress inetAddress, int n, GUID gUID) {
        super(F_LIME_VENDOR_ID, 22, 2, PushProxyAcknowledgement.derivePayload(inetAddress, n));
        this._addr = inetAddress;
        this._port = n;
        this.setGUID(gUID);
    }

    public int getListeningPort() {
        return this._port;
    }

    public InetAddress getListeningAddress() {
        return this._addr;
    }

    private static byte[] derivePayload(InetAddress inetAddress, int n) {
        try {
            QueryReply.IPPortCombo iPPortCombo = new QueryReply.IPPortCombo(inetAddress.getHostAddress(), n);
            return iPPortCombo.toBytes();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException.getMessage());
        }
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

