/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.ByteSetting;
import com.limegroup.gnutella.settings.CharArraySetting;
import com.limegroup.gnutella.settings.FileArraySetting;
import com.limegroup.gnutella.settings.FileSetSetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.FloatSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LongSetting;
import com.limegroup.gnutella.settings.PasswordSetting;
import com.limegroup.gnutella.settings.ProxyFileSetting;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.settings.StringArraySetting;
import com.limegroup.gnutella.settings.StringSetSetting;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class SettingsFactory {
    private static final long EXPIRY_INTERVAL = 1209600000L;
    private LongSetting LAST_EXPIRE_TIME = null;
    private File SETTINGS_FILE;
    private final String HEADING;
    protected final Properties DEFAULT_PROPS = new Properties();
    protected final Properties PROPS = new Properties(this.DEFAULT_PROPS);
    private ArrayList settings = new ArrayList(10);
    private Map simppKeyToSetting = new HashMap();
    private boolean expired = false;

    public SettingsFactory(File file) {
        this(file, "");
    }

    public SettingsFactory(File file, String string) {
        this.SETTINGS_FILE = file;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.HEADING = string;
        this.reload();
    }

    public synchronized Iterator iterator() {
        return this.settings.iterator();
    }

    public synchronized void reload() {
        Object object;
        if (!this.SETTINGS_FILE.isFile()) {
            this.setExpireValue();
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(this.SETTINGS_FILE);
                try {
                    this.PROPS.load(fileInputStream);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                }
                catch (IOException iOException) {
                    object = iOException.getMessage();
                    if (object != null && ((String)(object = ((String)object).toLowerCase())).indexOf("corrupted") == -1) {
                        throw iOException;
                    }
                    this.SETTINGS_FILE.delete();
                    MessageService.showError("ERROR_PROPS_CORRUPTED");
                }
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        Iterator iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            object = (Setting)iterator.next();
            ((Setting)object).reload();
        }
        this.setExpireValue();
    }

    private synchronized void setExpireValue() {
        if (this.LAST_EXPIRE_TIME == null) {
            this.LAST_EXPIRE_TIME = this.createLongSetting("LAST_EXPIRE_TIME", 0L);
            boolean bl = this.expired = this.LAST_EXPIRE_TIME.getValue() + 1209600000L < System.currentTimeMillis();
            if (this.expired) {
                this.LAST_EXPIRE_TIME.setValue(System.currentTimeMillis());
            }
        }
    }

    public synchronized void changeFile(File file) {
        this.SETTINGS_FILE = file;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.revertToDefault();
        this.reload();
    }

    public synchronized void revertToDefault() {
        Iterator iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            Setting setting = (Setting)iterator.next();
            setting.revertToDefault();
        }
    }

    public synchronized void save() {
        Object object;
        Properties properties = (Properties)this.PROPS.clone();
        Iterator iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            object = (Setting)iterator.next();
            if (((Setting)object).shouldAlwaysSave() || !((Setting)object).isDefault()) continue;
            properties.remove(((Setting)object).getKey());
        }
        object = null;
        try {
            try {
                File file;
                if (this.SETTINGS_FILE.isDirectory()) {
                    this.SETTINGS_FILE.delete();
                }
                if ((file = this.SETTINGS_FILE.getParentFile()) != null) {
                    file.mkdirs();
                    FileUtils.setWriteable(file);
                }
                FileUtils.setWriteable(this.SETTINGS_FILE);
                try {
                    object = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
                catch (IOException iOException) {
                    this.SETTINGS_FILE.delete();
                    object = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
                properties.store((OutputStream)object, this.HEADING);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (object != null) {
            try {
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    Properties getProperties() {
        return this.PROPS;
    }

    public synchronized StringSetting createStringSetting(String string, String string2) {
        StringSetting stringSetting = new StringSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(stringSetting, null);
        return stringSetting;
    }

    public synchronized StringSetting createSettableStringSetting(String string, String string2, String string3) {
        StringSetting stringSetting = new StringSetting(this.DEFAULT_PROPS, this.PROPS, string, string2, string3);
        this.handleSettingInternal(stringSetting, string3);
        return stringSetting;
    }

    public synchronized BooleanSetting createBooleanSetting(String string, boolean bl) {
        BooleanSetting booleanSetting = new BooleanSetting(this.DEFAULT_PROPS, this.PROPS, string, bl);
        this.handleSettingInternal(booleanSetting, null);
        return booleanSetting;
    }

    public synchronized BooleanSetting createSettableBooleanSetting(String string, boolean bl, String string2) {
        BooleanSetting booleanSetting = new BooleanSetting(this.DEFAULT_PROPS, this.PROPS, string, bl, string2);
        this.handleSettingInternal(booleanSetting, string2);
        return booleanSetting;
    }

    public synchronized IntSetting createIntSetting(String string, int n) {
        IntSetting intSetting = new IntSetting(this.DEFAULT_PROPS, this.PROPS, string, n);
        this.handleSettingInternal(intSetting, null);
        return intSetting;
    }

    public synchronized IntSetting createSettableIntSetting(String string, int n, String string2, int n2, int n3) {
        IntSetting intSetting = new IntSetting(this.DEFAULT_PROPS, this.PROPS, string, n, string2, n2, n3);
        this.handleSettingInternal(intSetting, string2);
        return intSetting;
    }

    public synchronized ByteSetting createByteSetting(String string, byte by) {
        ByteSetting byteSetting = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, string, by);
        this.handleSettingInternal(byteSetting, null);
        return byteSetting;
    }

    public synchronized ByteSetting createSettableByteSetting(String string, byte by, String string2, byte by2, byte by3) {
        ByteSetting byteSetting = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, string, by, string2, by2, by3);
        this.handleSettingInternal(byteSetting, string2);
        return byteSetting;
    }

    public synchronized LongSetting createLongSetting(String string, long l) {
        LongSetting longSetting = new LongSetting(this.DEFAULT_PROPS, this.PROPS, string, l);
        this.handleSettingInternal(longSetting, null);
        return longSetting;
    }

    public synchronized LongSetting createSettableLongSetting(String string, long l, String string2, long l2, long l3) {
        LongSetting longSetting = new LongSetting(this.DEFAULT_PROPS, this.PROPS, string, l, string2, l2, l3);
        this.handleSettingInternal(longSetting, string2);
        return longSetting;
    }

    public synchronized FileSetting createFileSetting(String string, File file) {
        Object object;
        String string2 = file.getParent();
        if (string2 != null && !((File)(object = new File(string2))).isDirectory()) {
            ((File)object).mkdirs();
        }
        object = new FileSetting(this.DEFAULT_PROPS, this.PROPS, string, file);
        this.handleSettingInternal((Setting)object, null);
        return object;
    }

    public synchronized FileSetting createSettableFileSetting(String string, File file, String string2) {
        Object object;
        String string3 = file.getParent();
        if (string3 != null && !((File)(object = new File(string3))).isDirectory()) {
            ((File)object).mkdirs();
        }
        object = new FileSetting(this.DEFAULT_PROPS, this.PROPS, string, file, string2);
        this.handleSettingInternal((Setting)object, string2);
        return object;
    }

    public synchronized ProxyFileSetting createProxyFileSetting(String string, FileSetting fileSetting) {
        ProxyFileSetting proxyFileSetting = new ProxyFileSetting(this.DEFAULT_PROPS, this.PROPS, string, fileSetting);
        this.handleSettingInternal(proxyFileSetting, null);
        return proxyFileSetting;
    }

    public synchronized CharArraySetting createCharArraySetting(String string, char[] cArray) {
        CharArraySetting charArraySetting = CharArraySetting.createCharArraySetting(this.DEFAULT_PROPS, this.PROPS, string, cArray);
        this.handleSettingInternal(charArraySetting, null);
        return charArraySetting;
    }

    public synchronized CharArraySetting createSettableCharArraySetting(String string, char[] cArray, String string2) {
        CharArraySetting charArraySetting = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, string, cArray, string2);
        this.handleSettingInternal(charArraySetting, string2);
        return charArraySetting;
    }

    public synchronized FloatSetting createFloatSetting(String string, float f) {
        FloatSetting floatSetting = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, string, f);
        this.handleSettingInternal(floatSetting, null);
        return floatSetting;
    }

    public synchronized FloatSetting createSettableFloatSetting(String string, float f, String string2, float f2, float f3) {
        FloatSetting floatSetting = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, string, f, string2, f2, f3);
        this.handleSettingInternal(floatSetting, string2);
        return floatSetting;
    }

    public synchronized StringArraySetting createStringArraySetting(String string, String[] stringArray) {
        StringArraySetting stringArraySetting = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray);
        this.handleSettingInternal(stringArraySetting, null);
        return stringArraySetting;
    }

    public synchronized StringArraySetting createSettableStringArraySetting(String string, String[] stringArray, String string2) {
        StringArraySetting stringArraySetting = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray, string2);
        this.handleSettingInternal(stringArraySetting, string2);
        return stringArraySetting;
    }

    public synchronized StringSetSetting createStringSetSetting(String string, String string2) {
        StringSetSetting stringSetSetting = new StringSetSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(stringSetSetting, null);
        return stringSetSetting;
    }

    public synchronized FileArraySetting createFileArraySetting(String string, File[] fileArray) {
        FileArraySetting fileArraySetting = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.handleSettingInternal(fileArraySetting, null);
        return fileArraySetting;
    }

    public synchronized FileArraySetting createSettableFileArraySetting(String string, File[] fileArray, String string2) {
        FileArraySetting fileArraySetting = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray, string2);
        this.handleSettingInternal(fileArraySetting, string2);
        return fileArraySetting;
    }

    public synchronized FileSetSetting createFileSetSetting(String string, File[] fileArray) {
        FileSetSetting fileSetSetting = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.handleSettingInternal(fileSetSetting, null);
        return fileSetSetting;
    }

    public synchronized FileSetSetting createSettableFileSetSetting(String string, File[] fileArray, String string2) {
        FileSetSetting fileSetSetting = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray, string2);
        this.handleSettingInternal(fileSetSetting, string2);
        return fileSetSetting;
    }

    public synchronized BooleanSetting createExpirableBooleanSetting(String string, boolean bl) {
        BooleanSetting booleanSetting = this.createBooleanSetting(string, bl);
        if (this.expired) {
            booleanSetting.revertToDefault();
        }
        return booleanSetting;
    }

    public synchronized IntSetting createExpirableIntSetting(String string, int n) {
        IntSetting intSetting = this.createIntSetting(string, n);
        if (this.expired) {
            intSetting.revertToDefault();
        }
        return intSetting;
    }

    public synchronized PasswordSetting createPasswordSettingMD5(String string, String string2) {
        PasswordSetting passwordSetting = new PasswordSetting(this.DEFAULT_PROPS, this.PROPS, "MD5", string, string2);
        this.handleSettingInternal(passwordSetting, null);
        return passwordSetting;
    }

    private synchronized void handleSettingInternal(Setting setting, String string) {
        this.settings.add(setting);
        setting.reload();
        if (string != null) {
            SimppSettingsManager simppSettingsManager = SimppSettingsManager.instance();
            String string2 = simppSettingsManager.getRemanentSimppValue(string);
            if (string2 != null) {
                simppSettingsManager.cacheUserPref(setting, setting.getValueAsString());
                setting.setValue(string2);
            }
            this.simppKeyToSetting.put(string, setting);
        }
    }

    synchronized Setting getSettingForSimppKey(String string) {
        return (Setting)this.simppKeyToSetting.get(string);
    }
}

