/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class SimppManager {
    private static final Log LOG;
    private static SimppManager INSTANCE;
    private int _latestVersion;
    private static final String SIMPP_FILE = "simpp.xml";
    private static int MIN_VERSION;
    private byte[] _simppBytes;
    private String _propsStream;
    private final ProcessingQueue _processingQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.simpp.SimppManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_VERSION = 3;
    }

    /*
     * Exception decompiling
     */
    private SimppManager() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized SimppManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new SimppManager();
        }
        return INSTANCE;
    }

    public int getVersion() {
        return this._latestVersion;
    }

    public byte[] getSimppBytes() {
        return this._simppBytes;
    }

    public String getPropsString() {
        return this._propsStream;
    }

    public void checkAndUpdate(final byte[] byArray) {
        if (byArray == null) {
            return;
        }
        final int n = this._latestVersion;
        Runnable runnable = new Runnable(){

            public void run() {
                SimppDataVerifier simppDataVerifier = new SimppDataVerifier(byArray);
                if (!simppDataVerifier.verifySource()) {
                    return;
                }
                SimppParser simppParser = null;
                try {
                    simppParser = new SimppParser(simppDataVerifier.getVerifiedData());
                }
                catch (SAXException sAXException) {
                    LOG.error((Object)"SAX error reading network simpp", (Throwable)sAXException);
                    return;
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOX parsing network simpp", (Throwable)iOException);
                    return;
                }
                int n3 = simppParser.getVersion();
                if (n3 <= n) {
                    LOG.error((Object)"Network simpp below current version, aborting.");
                    return;
                }
                SimppManager.this._latestVersion = n3;
                SimppManager.this._simppBytes = byArray;
                SimppManager.this._propsStream = simppParser.getPropsData();
                String string = simppParser.getPropsData();
                SimppSettingsManager.instance().updateSimppSettings(string);
                int n2 = 0;
                while (n2 < 5) {
                    if (SimppManager.this.save()) break;
                    ++n2;
                }
                CapabilitiesVM.reconstructInstance();
                RouterService.getConnectionManager().sendUpdatedCapabilities();
            }
        };
        this._processingQueue.add(runnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save() {
        FilterInputStream filterInputStream;
        File file;
        File file2;
        block26: {
            file2 = new File(CommonUtils.getUserSettingsDir(), "simpp.xml.tmp");
            file = new File(CommonUtils.getUserSettingsDir(), SIMPP_FILE);
            OutputStream outputStream = null;
            try {
                try {
                    outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    outputStream.write(this._simppBytes);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    if (outputStream == null) return false;
                    try {
                        outputStream.close();
                        return false;
                    }
                    catch (IOException iOException2) {}
                    return false;
                }
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            filterInputStream = null;
            byte[] byArray = new byte[this._simppBytes.length];
            try {
                filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                ((DataInputStream)filterInputStream).readFully(byArray);
                if (Arrays.equals(byArray, this._simppBytes)) break block26;
                if (filterInputStream == null) return false;
                try {
                    filterInputStream.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (IOException iOException) {
                try {
                    if (filterInputStream == null) return false;
                }
                catch (Throwable throwable) {
                    if (filterInputStream == null) throw throwable;
                    try {
                        filterInputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException3) {}
                    throw throwable;
                }
                try {
                    filterInputStream.close();
                    return false;
                }
                catch (IOException iOException4) {}
                return false;
            }
        }
        if (filterInputStream == null) return FileUtils.forceRename(file2, file);
        try {
            filterInputStream.close();
            return FileUtils.forceRename(file2, file);
        }
        catch (IOException iOException) {}
        return FileUtils.forceRename(file2, file);
    }
}

