/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Expand {
    private Expand() {
    }

    public static void expandFile(File file, File file2) throws IOException {
        Expand.expandFile(file, file2, false, null);
    }

    public static void expandFile(File file, File file2, boolean bl) throws IOException {
        Expand.expandFile(file, file2, bl, null);
    }

    public static void expandFile(File file, File file2, boolean bl, String[] stringArray) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            FileUtils.setWriteable(file);
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3 = new File(file2, zipEntry.getName());
                File file4 = new File(file3.getParent());
                file4.mkdirs();
                if (zipEntry.isDirectory()) {
                    file3.mkdirs();
                    continue;
                }
                if (zipEntry.getTime() <= file3.lastModified() && !bl && !Expand.inNames(zipEntry.getName(), stringArray)) continue;
                FileUtils.setWriteable(file3);
                byte[] byArray = new byte[1024];
                int n = 0;
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                    while ((n = zipInputStream.read(byArray)) >= 0) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(bufferedOutputStream);
                    throw throwable;
                }
                IOUtils.close(bufferedOutputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(zipInputStream);
            throw throwable;
        }
        IOUtils.close(zipInputStream);
    }

    private static boolean inNames(String string, String[] stringArray) {
        if (stringArray == null || string == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

