/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.SystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class FileUtils {
    public static void writeMap(String string, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(map);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    public static Map readMap(String string) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            Map map = (Map)objectInputStream.readObject();
            return map;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    public static String getCanonicalPath(File file) throws IOException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (CommonUtils.isWindows() && string != null && string.indexOf("There are no more files") != -1) {
                return file.getAbsolutePath();
            }
            throw iOException;
        }
    }

    public static File getCanonicalFile(File file) throws IOException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (CommonUtils.isWindows() && string != null && string.indexOf("There are no more files") != -1) {
                return file.getAbsoluteFile();
            }
            throw iOException;
        }
    }

    public static final boolean isReallyParent(File file, File file2) throws IOException {
        String string;
        String string2 = FileUtils.getCanonicalPath(file);
        return string2.equals(string = FileUtils.getCanonicalPath(file2.getAbsoluteFile().getParentFile()));
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return FileUtils.getFileExtension(string);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static boolean setWriteable(File file) {
        String string;
        if (!file.exists()) {
            return true;
        }
        if (file.canWrite()) {
            if (CommonUtils.isWindows()) {
                return true;
            }
            if (!file.isDirectory()) {
                return true;
            }
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        String[] stringArray = null;
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            SystemUtils.setWriteable(string);
        } else {
            stringArray = CommonUtils.isOS2() ? (String[])null : (file.isDirectory() ? new String[]{"chmod", "u+w+x", string} : new String[]{"chmod", "u+w", string});
        }
        if (stringArray != null) {
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return file.canWrite();
    }

    public static void touch(File file) throws IOException {
        block14: {
            if (file.exists()) {
                return;
            }
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                FileOutputStream fileOutputStream = null;
                try {
                    try {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    catch (IOException iOException2) {
                        iOException2.initCause(iOException);
                        throw iOException2;
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    throw throwable;
                }
                if (fileOutputStream == null) break block14;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException4) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceRename(File file, File file2) {
        FileDesc fileDesc;
        boolean bl = file.renameTo(file2);
        if (!bl && (fileDesc = RouterService.getFileManager().getFileDescForFile(file)) != null) {
            UploadManager uploadManager;
            UploadManager uploadManager2 = uploadManager = RouterService.getUploadManager();
            synchronized (uploadManager2) {
                if (uploadManager.killUploadsForFileDesc(fileDesc)) {
                    bl = file.renameTo(file2);
                }
            }
        }
        if (!bl && (bl = CommonUtils.copy(file, file2))) {
            file.delete();
        }
        return bl;
    }

    public static boolean verySafeSave(File file, String string, byte[] byArray) {
        File file2;
        try {
            file2 = File.createTempFile(string, "tmp", file);
        }
        catch (IOException iOException) {
            return false;
        }
        File file3 = new File(file, string);
        BufferedOutputStream bufferedOutputStream = null;
        try {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                ((OutputStream)bufferedOutputStream).write(byArray);
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                IOUtils.close(bufferedOutputStream);
                return false;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedOutputStream);
            throw throwable;
        }
        IOUtils.close(bufferedOutputStream);
        byte[] byArray2 = FileUtils.readFileFully(file2);
        if (byArray2 == null || !Arrays.equals(byArray2, byArray)) {
            return false;
        }
        return FileUtils.forceRename(file2, file3);
    }

    public static byte[] readFileFully(File file) {
        DataInputStream dataInputStream = null;
        int n = (int)file.length();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            try {
                dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                dataInputStream.readFully(byArray);
            }
            catch (IOException iOException) {
                byte[] byArray2 = null;
                IOUtils.close(dataInputStream);
                return byArray2;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(dataInputStream);
            throw throwable;
        }
        IOUtils.close(dataInputStream);
        return byArray;
    }

    public static File[] getFilesRecursive(File file, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray = new File[]{};
        if (file.exists() && file.isDirectory()) {
            arrayList.add(file);
        }
        while (arrayList.size() > 0) {
            File file2 = (File)arrayList.remove(0);
            String[] stringArray2 = file2.list();
            int n = 0;
            while (stringArray2 != null && n < stringArray2.length) {
                File file3 = new File(file2, stringArray2[n]);
                if (file3.isDirectory()) {
                    arrayList.add(file3);
                } else if (file3.isFile()) {
                    boolean bl = false;
                    if (stringArray == null) {
                        bl = true;
                    } else {
                        String string = FileUtils.getFileExtension(file3);
                        int n2 = 0;
                        while (n2 < stringArray.length && string != null) {
                            if (string.equalsIgnoreCase(stringArray[n2])) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (bl) {
                        arrayList2.add(file3);
                    }
                }
                ++n;
            }
        }
        if (!arrayList2.isEmpty()) {
            fileArray = new File[arrayList2.size()];
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n] = (File)arrayList2.get(n);
                ++n;
            }
        }
        return fileArray;
    }
}

