/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class FixedsizePriorityQueue {
    private SortedSet tree;
    private int capacity;
    private Comparator comparator;
    private static int nextID = 0;
    static boolean DEBUG = false;

    public FixedsizePriorityQueue(Comparator comparator, int n) throws IllegalArgumentException {
        this.comparator = comparator;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.tree = new TreeSet();
        this.capacity = n;
    }

    public Object insert(Object object) {
        this.repOk();
        Node node = new Node(object);
        if (this.size() < this.capacity()) {
            boolean bl = this.tree.add(node);
            Assert.that(bl);
            this.repOk();
            return null;
        }
        Node node2 = (Node)this.tree.first();
        if (node.compareTo(node2) > 0) {
            this.tree.remove(node2);
            boolean bl = this.tree.add(node);
            Assert.that(bl);
            this.repOk();
            return node2.getData();
        }
        this.repOk();
        return object;
    }

    public Object getMax() throws NoSuchElementException {
        return ((Node)this.tree.last()).getData();
    }

    public Object getMin() throws NoSuchElementException {
        return ((Node)this.tree.first()).getData();
    }

    public boolean contains(Object object) {
        Iterator iterator = this.tree.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(((Node)iterator.next()).getData())) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.tree.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(((Node)iterator.next()).getData())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new DataIterator();
    }

    public int size() {
        return this.tree.size();
    }

    public int capacity() {
        return this.capacity;
    }

    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        Assert.that(this.size() <= this.capacity());
        Iterator iterator = this.tree.iterator();
        while (iterator.hasNext()) {
            Assert.that(iterator.next() instanceof Node);
        }
    }

    public String toString() {
        return this.tree.toString();
    }

    private final class Node
    implements Comparable {
        private final Object data;
        private final int myID;

        Node(Object object) {
            this.data = object;
            int n = nextID;
            nextID = n + 1;
            this.myID = n;
        }

        public Object getData() {
            return this.data;
        }

        public int compareTo(Object object) {
            Node node = (Node)object;
            int n = FixedsizePriorityQueue.this.comparator.compare(this.getData(), node.getData());
            if (n != 0) {
                return n;
            }
            return this.myID - node.myID;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            return this.compareTo(object) == 0;
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class DataIterator
    implements Iterator {
        Iterator delegate;

        DataIterator() {
            this.delegate = FixedsizePriorityQueue.this.tree.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            return ((Node)this.delegate.next()).getData();
        }

        public void remove() {
            this.delegate.remove();
        }
    }
}

