/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;

public class AqDispatcher {
    private static int currentQueryIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dispatchCommand(List list) throws Exception {
        int n;
        String string = (String)list.get(0);
        String string2 = list.size() > 1 ? (String)list.get(1) : "";
        try {
            n = new Integer(string2);
        }
        catch (Exception exception) {
            n = 0;
        }
        if (string.equals("setEnableUltrapeer")) {
            UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(n == 0);
        } else if (string.equals("query")) {
            GUID gUID = new GUID(RouterService.newQueryGUID());
            String string3 = String.valueOf(++currentQueryIndex);
            AqEventHandler.queriesToIndices.put(gUID, string3);
            AqEventHandler.indicesToQueries.put(string3, gUID);
            RouterService.query(gUID.bytes(), StringUtils.createQueryString(string2), "", null);
        } else if (string.equals("queryWhatIsNew")) {
            GUID gUID = new GUID(RouterService.newQueryGUID());
            String string4 = String.valueOf(++currentQueryIndex);
            AqEventHandler.queriesToIndices.put(gUID, string4);
            AqEventHandler.indicesToQueries.put(string4, gUID);
            RouterService.queryWhatIsNew(gUID.bytes(), null);
        } else if (string.equals("removeQuery")) {
            int n2 = 1;
            while (n2 < list.size()) {
                String string5 = (String)list.get(n2);
                GUID gUID = (GUID)AqEventHandler.indicesToQueries.get(string5);
                if (gUID != null) {
                    String string6;
                    Iterator iterator;
                    RouterService.stopQuery(gUID);
                    AqEventHandler.queriesToIndices.remove(gUID);
                    AqEventHandler.indicesToQueries.remove(string5);
                    string5 = String.valueOf(string5) + ":";
                    Map map = AqEventHandler.queryGUIDs;
                    synchronized (map) {
                        iterator = AqEventHandler.queryGUIDs.keySet().iterator();
                        while (iterator.hasNext()) {
                            string6 = (String)iterator.next();
                            if (!string6.startsWith(string5)) continue;
                            iterator.remove();
                        }
                    }
                    map = AqEventHandler.responses;
                    synchronized (map) {
                        iterator = AqEventHandler.responses.keySet().iterator();
                        while (iterator.hasNext()) {
                            string6 = (String)iterator.next();
                            if (!string6.startsWith(string5)) continue;
                            iterator.remove();
                        }
                    }
                    map = AqEventHandler.alts;
                    synchronized (map) {
                        iterator = AqEventHandler.alts.keySet().iterator();
                        while (iterator.hasNext()) {
                            string6 = (String)iterator.next();
                            if (!string6.startsWith(string5)) continue;
                            iterator.remove();
                        }
                    }
                }
                ++n2;
            }
        } else if (string.equals("removeAllQueries")) {
            Map map = AqEventHandler.queriesToIndices;
            synchronized (map) {
                Iterator iterator = AqEventHandler.queriesToIndices.keySet().iterator();
                while (iterator.hasNext()) {
                    RouterService.stopQuery((GUID)iterator.next());
                }
            }
            AqEventHandler.queriesToIndices.clear();
            AqEventHandler.indicesToQueries.clear();
            AqEventHandler.queryGUIDs.clear();
            AqEventHandler.responses.clear();
            AqEventHandler.alts.clear();
        } else if (string.equals("clearAllResults")) {
            int n3 = 1;
            while (n3 < list.size()) {
                String string7 = (String)list.get(n3);
                GUID gUID = (GUID)AqEventHandler.indicesToQueries.get(string7);
                if (gUID != null) {
                    String string8;
                    Iterator iterator;
                    string7 = String.valueOf(string7) + ":";
                    Map map = AqEventHandler.queryGUIDs;
                    synchronized (map) {
                        iterator = AqEventHandler.queryGUIDs.keySet().iterator();
                        while (iterator.hasNext()) {
                            string8 = (String)iterator.next();
                            if (!string8.startsWith(string7)) continue;
                            iterator.remove();
                        }
                    }
                    map = AqEventHandler.responses;
                    synchronized (map) {
                        iterator = AqEventHandler.responses.keySet().iterator();
                        while (iterator.hasNext()) {
                            string8 = (String)iterator.next();
                            if (!string8.startsWith(string7)) continue;
                            iterator.remove();
                        }
                    }
                    map = AqEventHandler.alts;
                    synchronized (map) {
                        iterator = AqEventHandler.alts.keySet().iterator();
                        while (iterator.hasNext()) {
                            string8 = (String)iterator.next();
                            if (!string8.startsWith(string7)) continue;
                            iterator.remove();
                        }
                    }
                }
                ++n3;
            }
        } else if (string.equals("setAdultFilter")) {
            FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(n == 1);
            FilterSettings.FILTER_ADULT.setValue(n == 1);
        } else if (string.equals("clearWords")) {
            String[] stringArray = new String[]{};
            FilterSettings.BANNED_WORDS.setValue(stringArray);
        } else if (string.equals("addWord")) {
            List<String> list2 = Arrays.asList(FilterSettings.BANNED_WORDS.getValue());
            ArrayList<String> arrayList = new ArrayList<String>(list2);
            arrayList.add(string2);
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            FilterSettings.BANNED_WORDS.setValue(stringArray);
        } else if (string.equals("removeWord")) {
            List<String> list3 = Arrays.asList(FilterSettings.BANNED_WORDS.getValue());
            ArrayList<String> arrayList = new ArrayList<String>(list3);
            arrayList.remove(string2);
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            FilterSettings.BANNED_WORDS.setValue(stringArray);
        } else if (string.equals("finishFilterSettings")) {
            RouterService.adjustSpamFilters();
        } else if (string.equals("download")) {
            Object object;
            Object object2;
            GUID gUID = (GUID)AqEventHandler.queryGUIDs.get(string2);
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            int n4 = 1;
            while (n4 < list.size()) {
                object2 = (String)list.get(n4);
                Object v = AqEventHandler.responses.get(object2);
                object = AqEventHandler.alts.get(object2);
                if (v != null && object != null) {
                    hashSet.add(v);
                    hashSet2.addAll((Set)object);
                }
                ++n4;
            }
            RemoteFileDesc[] remoteFileDescArray = hashSet.toArray(new RemoteFileDesc[hashSet.size()]);
            object2 = null;
            int n5 = 0;
            while (n5 < remoteFileDescArray.length) {
                object = remoteFileDescArray[n5];
                ((RemoteFileDesc)object).setDownloading(true);
                ((RemoteFileDesc)object).setRetryAfter(0);
                if (((RemoteFileDesc)object).getSHA1Urn() != null) {
                    object2 = object;
                }
                hashSet2.remove(new Endpoint(((RemoteFileDesc)object).getHost(), ((RemoteFileDesc)object).getPort()));
                ++n5;
            }
            if (object2 == null) {
                object2 = remoteFileDescArray[0];
            }
            LinkedList<RemoteFileDesc> linkedList = new LinkedList<RemoteFileDesc>();
            object = hashSet2.iterator();
            while (object.hasNext()) {
                Endpoint endpoint = (Endpoint)object.next();
                linkedList.add(new RemoteFileDesc((RemoteFileDesc)object2, endpoint));
            }
            RouterService.download(remoteFileDescArray, linkedList, gUID, false);
        } else if (string.equals("pauseDownload")) {
            Iterator iterator = AqEventHandler.downloads.iterator();
            while (iterator.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                if (managedDownloader == null || managedDownloader.hashCode() != n || !managedDownloader.isActive()) continue;
                managedDownloader.pause();
                break;
            }
        } else if (string.equals("retryDownload")) {
            Iterator iterator = AqEventHandler.downloads.iterator();
            while (iterator.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                if (managedDownloader == null || managedDownloader.hashCode() != n || !managedDownloader.isInactive()) continue;
                managedDownloader.resume();
                break;
            }
        } else if (string.equals("cancelDownload")) {
            Iterator iterator = AqEventHandler.downloads.iterator();
            while (iterator.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                if (managedDownloader == null || managedDownloader.hashCode() != n) continue;
                managedDownloader.manualCancel();
                break;
            }
        } else if (string.equals("restoreIncompleteFiles")) {
            File file = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
            File[] fileArray = file.listFiles();
            int n6 = 0;
            while (n6 < fileArray.length) {
                File file2 = fileArray[n6];
                if (file2.getName().startsWith("T-") && file2.canRead() && file2.canWrite()) {
                    try {
                        RouterService.download(file2);
                    }
                    catch (Exception exception) {}
                }
                ++n6;
            }
        } else if (string.equals("setMaxSimDownload")) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(n);
        } else if (string.equals("setDownloadSpeed")) {
            int n7 = DownloadSettings.DOWNLOAD_SPEED.getValue();
            DownloadSettings.DOWNLOAD_SPEED.setValue(n);
            if (n != n7) {
                HTTPDownloader.applyRate();
            }
        } else if (string.equals("cancelUpload")) {
            Iterator iterator = AqEventHandler.uploads.iterator();
            while (iterator.hasNext()) {
                Uploader uploader = (Uploader)iterator.next();
                if (uploader == null || uploader.hashCode() != n) continue;
                uploader.stop();
                break;
            }
        } else if (string.equals("setMaxUploads")) {
            UploadSettings.HARD_MAX_UPLOADS.setValue(n);
        } else if (string.equals("setUploadsPerPerson")) {
            UploadSettings.UPLOADS_PER_PERSON.setValue(n);
        } else if (string.equals("setUploadSpeed")) {
            UploadSettings.UPLOAD_SPEED.setValue(n);
        } else if (string.equals("setAllowPartialSharing")) {
            UploadSettings.ALLOW_PARTIAL_SHARING.setValue(n == 1);
        } else if (string.equals("closeConnection")) {
            int n8 = new Integer((String)list.get(2));
            Iterator iterator = RouterService.getConnectionManager().getConnections().iterator();
            while (iterator.hasNext()) {
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (managedConnection == null || !managedConnection.getAddress().equals(string2) || managedConnection.getPort() != n8) continue;
                RouterService.removeConnection(managedConnection);
                break;
            }
        } else if (string.equals("awakeConnection")) {
            RouterService.disconnect();
            RouterService.connect();
        } else if (string.equals("setConnectionSpeed")) {
            ConnectionSettings.CONNECTION_SPEED.setValue(n);
        } else if (string.equals("setPort")) {
            int n9 = ConnectionSettings.PORT.getValue();
            if (n != n9 && NetworkUtils.isValidPort(n)) {
                try {
                    ConnectionSettings.PORT.setValue(n);
                    RouterService.setListeningPort(n);
                    RouterService.addressChanged();
                }
                catch (Exception exception) {
                    ConnectionSettings.PORT.revertToDefault();
                }
            }
        } else if (string.equals("setUPnPType")) {
            int n10;
            int n11 = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            int n12 = ConnectionSettings.FORCED_PORT.getValue();
            if (n == 0) {
                if (!ConnectionSettings.UPNP_IN_USE.getValue()) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                }
                ConnectionSettings.DISABLE_UPNP.setValue(false);
            } else if (n == 1) {
                n10 = ConnectionSettings.PORT.getValue();
                ConnectionSettings.DISABLE_UPNP.setValue(false);
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                ConnectionSettings.UPNP_IN_USE.setValue(false);
                ConnectionSettings.FORCED_PORT.setValue(n10);
            } else if (n == 2) {
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                ConnectionSettings.DISABLE_UPNP.setValue(true);
            }
            n10 = ConnectionSettings.FORCE_IP_ADDRESS.getValue() ? 1 : 0;
            int n13 = ConnectionSettings.FORCED_PORT.getValue();
            if (n10 != n11 || n10 != 0 && n12 != n13) {
                RouterService.addressChanged();
            }
        } else if (string.equals("setUsesLocalePreferencing")) {
            ConnectionSettings.USE_LOCALE_PREF.setValue(n == 1);
        } else if (string.equals("doBrowseHost")) {
            GUID gUID = new GUID(RouterService.newQueryGUID());
            String string9 = String.valueOf(++currentQueryIndex);
            AqEventHandler.queriesToIndices.put(gUID, string9);
            AqEventHandler.indicesToQueries.put(string9, gUID);
            String string10 = string2;
            int n14 = new Integer((String)list.get(2));
            HostData hostData = (HostData)AqEventHandler.hosts.get(String.valueOf(string10) + ":" + n14);
            if (hostData != null) {
                RouterService.doAsynchronousBrowseHost(string10, n14, gUID, new GUID(hostData.getClientGUID()), hostData.getPushProxies(), hostData.supportsFWTransfer());
            } else {
                RouterService.doAsynchronousBrowseHost(string10, n14, gUID, null, null, false);
            }
        } else if (string.equals("setDirectories")) {
            HashSet<File> hashSet = new HashSet<File>();
            int n15 = 1;
            while (n15 < list.size()) {
                File file;
                String string11 = (String)list.get(n15);
                if (!string11.equals("") && (file = new File(string11)) != null) {
                    hashSet.add(file);
                }
                ++n15;
            }
            Set set = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
            if (!hashSet.equals(set)) {
                SharingSettings.DIRECTORIES_TO_SHARE.setValue(hashSet);
                RouterService.getFileManager().loadSettings();
            }
        } else if (string.equals("setSaveDirectory")) {
            if (string2.equals("")) {
                SharingSettings.setSaveDirectory(SharingSettings.DEFAULT_SAVE_DIR);
            } else {
                SharingSettings.setSaveDirectory(new File(string2));
            }
        } else if (string.equals("setIncompletePurgeTime")) {
            SharingSettings.INCOMPLETE_PURGE_TIME.setValue(n);
        } else if (string.equals("setAllowFreeloaders")) {
            if (n == 1) {
                SharingSettings.FREELOADER_ALLOWED.setValue(100);
            } else {
                SharingSettings.FREELOADER_ALLOWED.setValue(0);
            }
        } else if (string.equals("setFreeloaderFiles")) {
            SharingSettings.FREELOADER_FILES.setValue(n);
        } else if (string.equals("setAllowCompleteSharing")) {
            SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.setValue(n == 1);
        } else if (string.equals("setProxyType")) {
            ConnectionSettings.CONNECTION_METHOD.setValue(n);
        } else if (string.equals("setProxyServer")) {
            ConnectionSettings.PROXY_HOST.setValue(string2);
        } else if (string.equals("setProxyPort")) {
            ConnectionSettings.PROXY_PORT.setValue(n);
        } else if (string.equals("setProxyUsername")) {
            ConnectionSettings.PROXY_USERNAME.setValue(string2);
        } else if (string.equals("setProxyPassword")) {
            ConnectionSettings.PROXY_PASS.setValue(string2);
        } else if (string.equals("setProxyPrivate")) {
            ConnectionSettings.USE_PROXY_FOR_PRIVATE.setValue(n == 1);
        } else if (string.equals("setRequiresAuthentication")) {
            ConnectionSettings.PROXY_AUTHENTICATE.setValue(n == 1);
        } else if (string.equals("setLanguage")) {
            if (string2.equals("")) {
                ApplicationSettings.LANGUAGE.revertToDefault();
            } else {
                ApplicationSettings.LANGUAGE.setValue(string2);
            }
        } else if (string.equals("initComplete")) {
            AqEvent.signalEvent(99);
        } else if (string.equals("shutdown")) {
            AqMain.shouldShutdown = true;
        } else {
            System.err.println("AqDispatcher: Unhandled command: " + list);
        }
    }
}

