/*
 * Copyright (c) 2002-2004 David Keiichi Watanabe
 * davew@xlife.org
 *
 * Modified by (c) 2004-2006 heavy_baby
 * heavy_baby@users.sourceforge.jp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.sourceforge.cabos;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.spam.SpamManager;

public class AqEventHandler implements ActivityCallback {
	/* Instances */

	private static final Log LOG = LogFactory.getLog(AqEventHandler.class);

	protected static Map hosts = new HashMap();

	protected static Map queriesToIndices = new HashMap();

	protected static Map indicesToQueries = new HashMap();

	protected static Map queryGUIDs = new HashMap();

	protected static Map responses = new HashMap();

	protected static Map locations = new HashMap();

	/* Network */

	public void addressStateChanged() {
	}

	public void connectionInitializing(Connection c) {
	}

	public void connectionInitialized(Connection c) {
		AqEvent.signalEvent(AqEvent.kLWEventConnectionInitialized, c);
	}

	public void connectionClosed(Connection c) {
		AqEvent.signalEvent(AqEvent.kLWEventConnectionClosed, c);
	}

	public void disconnected() {
	}

	/* Searching */

	public void handleQueryResult(RemoteFileDesc rfd, HostData data, Set locs) {
		if (SpamManager.instance().isSpam(rfd))
			return;
		if (!queriesToIndices.containsKey(new GUID(data.getMessageGUID())))
			return;

		AqEvent.signalEvent(AqEvent.kLWEventQueryResult, rfd, data, locs);
	}

	public void handleQueryString(String query) {
	}

	/* Upload */

	public void addUpload(Uploader u) {
		AqEvent.signalEvent(AqEvent.kLWEventAddUpload, u);
	}

	public void removeUpload(Uploader u) {
		AqEvent.signalEvent(AqEvent.kLWEventUpdateUploadStats, u);
		AqEvent.signalEvent(AqEvent.kLWEventRemoveUpload, u);
	}

	/* Browsing */

	public void browseHostFailed(GUID guid) {
	}

	/* Sharing */

	public void fileManagerLoading() {
	}

	public void fileManagerLoaded() {
	}

	public boolean warnAboutSharingSensitiveDirectory(final File dir) {
		return false;
	}

	public void handleFileEvent(FileManagerEvent evt) {
		if (evt.isAddEvent()) {
			FileDesc[] files = evt.getFileDescs();
			for (int i = 0; i < files.length; i++)
				AqEvent.signalEvent(AqEvent.kLWEventAddSharedFile, files[i]);
		}
	}

	public void handleSharedFileUpdate(File file) {
	}

	public void setAnnotateEnabled(boolean enabled) {
	}

	/* Notifications */

	public void uploadsComplete() {
	}

	public void restoreApplication() {
	}

	public boolean isQueryAlive(GUID guid) {
		return queriesToIndices.containsKey(guid);
	}

	public void componentLoading(String component) {
		LOG.info(component);
	}

	public void acceptedIncomingChanged(boolean status) {
	}

	/* DownloadCallback */

	public void addDownload(Downloader d) {
		AqEvent.signalEvent(AqEvent.kLWEventAddDownload, d);
	}

	public void removeDownload(Downloader d) {
		AqEvent.signalEvent(AqEvent.kLWEventUpdateDownloadStats, d);
		AqEvent.signalEvent(AqEvent.kLWEventRemoveDownload, d);
	}

	public void downloadsComplete() {
	}

	public void showDownloads() {
	}

	public void promptAboutCorruptDownload(Downloader dloader) {
		dloader.discardCorruptDownload(true);
	}

	public String getHostValue(String key) {
		return null;
	}

}