/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import java.util.HashMap;
import java.util.Iterator;

public class DaapSession {
    private final long creationTime = System.currentTimeMillis();
    private final HashMap attributes = new HashMap();
    private final Integer sessionId;
    private boolean valid;
    private long lastAccesedTime;
    private int maxInactiveTime;

    public DaapSession(Integer sessionId) {
        this.sessionId = sessionId;
        this.valid = true;
        this.lastAccesedTime = this.creationTime;
        this.maxInactiveTime = 1800;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public synchronized long getLastAccessedTime() {
        return this.lastAccesedTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public synchronized int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public synchronized void setMaxInactiveTime(int maxInactiveTime) {
        this.maxInactiveTime = maxInactiveTime;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    public synchronized void invalidate() {
        this.valid = false;
        this.attributes.clear();
    }

    public synchronized Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public synchronized Object setAttribute(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public synchronized Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public synchronized Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public synchronized boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    synchronized void update() {
        this.lastAccesedTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("class: ").append(this.getClass().getName()).append("\n");
        buffer.append(" sessionId: ").append(this.sessionId).append("\n");
        buffer.append(" maxInactiveTime: ").append(this.maxInactiveTime).append("\n");
        buffer.append(" creationTime: ").append(this.creationTime).append("\n");
        buffer.append(" lastAccesedTime: ").append(this.lastAccesedTime).append("\n");
        buffer.append(" valid: ").append(this.valid).append("\n");
        buffer.append(" attributes: ").append(this.attributes).append("\n");
        return buffer.toString();
    }
}

