/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.ByteUtil;
import de.kapsi.net.daap.chunks.AbstractChunk;
import java.io.IOException;
import java.io.OutputStream;

public class IntChunk
extends AbstractChunk {
    private int value;

    protected IntChunk(String type, String name, int value) {
        super(type, name);
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getLength() {
        return 4;
    }

    public int getType() {
        return 5;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        byte[] dst = new byte[4];
        ByteUtil.toByteBE(this.value, dst, 0);
        out.write(dst, 0, dst.length);
    }

    public String toString() {
        return super.toString() + "=" + this.value;
    }
}

