/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptCBC;
import org.logi.crypto.modes.EncryptCBC;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.DHEKEKeyEx;
import org.logi.crypto.protocols.InterAuthClient;
import org.logi.crypto.protocols.InterKeyExClient;
import org.logi.crypto.protocols.InterProtocolClient;
import org.logi.crypto.protocols.ValidationException;

public class DHEKEKeyExClient
extends DHEKEKeyEx
implements InterProtocolClient,
InterKeyExClient,
InterAuthClient {
    private int nextStep = 1;

    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        try {
            switch (this.nextStep) {
                case 1: {
                    if (byArray != null) {
                        throw new CryptoProtocolException("The client should always send the first message");
                    }
                    ++this.nextStep;
                    return this.myPublic.toByteArray();
                }
                case 2: {
                    byte[] byArray2;
                    byte[] byArray3;
                    int n;
                    if (byArray == null) {
                        throw new CryptoProtocolException("Message expected");
                    }
                    ++this.nextStep;
                    try {
                        n = (int)Crypto.makeLong(byArray, 0, 2);
                        byArray3 = new DecryptCBC(this.secretKey).decrypt(byArray, 2, n);
                        int n2 = (int)Crypto.makeLong(byArray3, 0, 2);
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray3, 2, byArray2, 0, n2);
                        BigInteger bigInteger = new BigInteger(1, byArray2);
                        byte[] byArray4 = bigInteger.modPow(this.myPrivate, this.m).toByteArray();
                        try {
                            this.sessionKey = Crypto.makeSessionKey(this.keyType, byArray4);
                            this.pbs = this.sessionKey.plainBlockSize();
                            this.cbs = this.sessionKey.plainBlockSize();
                        }
                        catch (InvalidCDSException invalidCDSException) {
                            throw new CryptoProtocolException(invalidCDSException.getMessage());
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ValidationException("The server does not know the secret.");
                    }
                    byte[] byArray5 = new byte[this.sessionKey.plainBlockSize()];
                    this.sessionKey.decrypt(byArray, 2 + n, byArray5, 0);
                    this.myRandom = new byte[this.pbs];
                    random.nextBytes(this.myRandom);
                    byArray2 = new byte[byArray5.length + this.myRandom.length];
                    System.arraycopy(this.myRandom, 0, byArray2, 0, this.myRandom.length);
                    System.arraycopy(byArray5, 0, byArray2, this.myRandom.length, byArray5.length);
                    byArray3 = new EncryptCBC(this.sessionKey).flush(byArray2, 0, byArray2.length);
                    return byArray3;
                }
                case 3: {
                    if (byArray == null) {
                        throw new CryptoProtocolException("Message expected");
                    }
                    ++this.nextStep;
                    byte[] byArray6 = new byte[this.pbs];
                    this.sessionKey.decrypt(byArray, 0, byArray6, 0);
                    if (!Crypto.equal(this.myRandom, byArray6)) {
                        throw new ValidationException("The server does not know the secret");
                    }
                    this.completed = true;
                    return null;
                }
            }
            throw new CryptoProtocolException("The protocol has been completed");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public DHEKEKeyExClient(int n, String string, CipherKey cipherKey) {
        super(n, string, cipherKey);
    }
}

