/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.impl;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.system.SystemManager;

public class LazyInitializedCommand
extends CommandWrapper {
    private final String _name;
    private final String _className;
    private Command _command;

    private LazyInitializedCommand() {
        this._name = null;
        this._className = null;
    }

    public LazyInitializedCommand(String name, String className) {
        if (name == null || className == null) {
            throw new IllegalArgumentException("illegal xml format : " + name + " = " + className);
        }
        this._name = name;
        this._className = className;
    }

    public String getName() {
        return this._name;
    }

    public String executeImpl(SystemManager manager, String[] args) throws CommandFatalException, CommandException {
        if (this._command == null) {
            try {
                Object command = Thread.currentThread().getContextClassLoader().loadClass(this._className).newInstance();
                this._command = (Command)command;
            }
            catch (Exception e) {
                throw new CommandFatalException(e);
            }
        }
        return this._command.execute(manager, args);
    }

    public String toString() {
        return this._className;
    }
}

