/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.system.CommandQueue;
import jp.sourceforge.cafebabe.system.SystemManager;

public final class STDInputManager
extends InputManager
implements Runnable {
    private final SystemManager _manager;

    public STDInputManager(SystemManager manager, CommandQueue queue) {
        super(queue);
        this._manager = manager;
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String buff = null;
                while ((buff = reader.readLine()) != null) {
                    this.addCommand(buff.trim());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.addCommand(new String[]{"exit"});
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.addCommand(new String[]{"exit"});
    }

    private void addCommand(String commandStr) {
        String[] command = commandStr.split(";");
        int i = 0;
        while (i < command.length) {
            String com = null;
            if (command[i].startsWith("@") && (com = this._manager.getMacro(command[i].trim())) != null) {
                this.addCommand(com);
                return;
            }
            this.addCommand(this.parse(command[i]));
            ++i;
        }
    }

    private String[] parse(String commandStr) {
        int begin = 0;
        boolean inQuote = false;
        boolean isEscape = false;
        ArrayList<String> ret = new ArrayList<String>();
        char[] commands = commandStr.trim().toCharArray();
        int i = 0;
        while (i <= commandStr.length()) {
            int c = 0;
            if (i < commandStr.length()) {
                c = commands[i];
            } else {
                c = 32;
                inQuote = false;
            }
            switch (c) {
                case 32: {
                    if (!inQuote) {
                        String str = new String(commands, begin, i - begin);
                        if (str.length() > 0 && !str.equals(" ")) {
                            ret.add(str);
                        }
                        begin = i + 1;
                    }
                    isEscape = false;
                    break;
                }
                case 92: {
                    if (isEscape) {
                        isEscape = false;
                        break;
                    }
                    isEscape = true;
                    break;
                }
                case 34: {
                    if (!isEscape) {
                        inQuote = !inQuote;
                    }
                    isEscape = false;
                    break;
                }
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }
}

