/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.impl.RootCommandSet;
import jp.sourceforge.cafebabe.system.CommandQueue;

public class SystemManager {
    public static final String ROOT_SET = "root";
    public static final String EXIT = "exit";
    private final String _appName;
    private CommandQueue _commandQueue;
    private InputManager _inputManager;
    private RootCommandSet _root;
    private final Map _env;
    private final Map _macro;
    private CommandWrapper _commandWrapper;
    private boolean _isShotdowned;

    SystemManager(String appName) {
        this._appName = appName;
        this._env = new HashMap();
        this._macro = new HashMap();
    }

    void setRootCommandSet(RootCommandSet root) {
        this._root = root;
    }

    public RootCommandSet getRootCommandSet() {
        return this._root;
    }

    public CommandSet getGlobal() {
        return (CommandSet)this._root.getCommand("global");
    }

    public CommandQueue getCommandQueue() {
        return this._commandQueue;
    }

    void setCommandQueue(CommandQueue queue) {
        this._commandQueue = queue;
    }

    public InputManager getInputManager() {
        return this._inputManager;
    }

    void setInputManager(InputManager manager) {
        this._inputManager = manager;
    }

    public void setEnv(String key, Serializable value) {
        this._env.put(key, value);
    }

    public Object getEnv(String key) {
        return this._env.get(key);
    }

    public String[] getInput() {
        return this.getInput(this._appName);
    }

    public String[] getInput(String msg) {
        return this._commandQueue.dequeue(msg);
    }

    public void setWrapper(CommandWrapper parent) {
        this._commandWrapper = parent;
    }

    public void removeWrapper() {
        this._commandWrapper = null;
    }

    public CommandWrapper getWrapper() {
        return this._commandWrapper;
    }

    public void addMacro(String name, String macro) {
        this._macro.put(name, macro);
    }

    public String getMacro(String name) {
        return (String)this._macro.get(name);
    }

    protected void start() throws CommandFatalException, CommandException {
        String ret = null;
        do {
            this._root.execute(this, new String[]{ROOT_SET});
        } while (ret != null && !ret.equals(EXIT) && !ret.equals("fatal"));
    }

    public void shutdown() {
        if (!this._isShotdowned) {
            this._isShotdowned = true;
        }
    }

    public static interface BootDefine {
        public static final String NOT_MATCH_ASTERISK = "cafebabe.forward.notmatchasterisk";
    }
}

