/*
 * 쐬: 2005/06/01
 */
package jp.sourceforge.cafebabe.psh;

import java.io.File;
import java.io.IOException;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.system.CAFEBabe;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * cd s܂B
 * @author jin_k
 */
public class CD implements Command {
	/*
	 * ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager,
	 *      java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args) {
		if (args.length < 2) {
			return ERROR;
		}
		try {
			File current = (File) manager.getEnv(PshDefine.DIR_CURRENT);
			if (null == current) {
				current = new File(System.getProperty(CAFEBabe.DIR_ROOT));
				manager.setEnv(PshDefine.DIR_CURRENT, current);
			}
			File dir = new File(args[1]);
			if (dir.isAbsolute()) {
				dir = dir.getCanonicalFile();
			} else {
				dir = new File(current, args[1]).getCanonicalFile();
			}

			if (dir.exists()) {
				manager.setEnv(PshDefine.DIR_CURRENT, dir);
				return SUCCESS;
			} else {
				return ERROR;
			}
		} catch (IOException ioe) {
			return ERROR;
		}
	}

}
