/*
 * 쐬: 2005/01/21
 */
package jp.sourceforge.cafebabe.impl;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * @author jin_k
 */
public class LazyInitializedCommand extends CommandWrapper {
	/** R}hłB */
	private final String _name;

	/** R}hNXłB */
	private final String _className;

	/** R}h{̂łB */
	private Command _command;

	////
	//	RXgN^
	//
	/**
	 * !! private !!
	 */
	private LazyInitializedCommand() {
		_name = null;
		_className = null;
	}

	/**
	 * xR}h𐶐܂B
	 * @param name R}h
	 * @param className FQCN
	 */
	public LazyInitializedCommand(String name, String className) {
		if (null == name || null == className) {
			throw new IllegalArgumentException("illegal xml format : " + name
					+ " = " + className);
		}
		_name = name;
		_className = className;
	}

	/*
	 * ( Javadoc)
	 * @see commandline.system.framework.Command#getName()
	 */
	public String getName() {
		return _name;
	}

	/*
	 *  ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.CommandWrapper#executeImpl(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String executeImpl(SystemManager manager, String[] args)
			throws CommandFatalException, CommandException {
		if (null == _command) {
			try {
				Object command = Thread.currentThread().getContextClassLoader()
						.loadClass(_className).newInstance();
				//IFĂȂꍇAClassCastException
				_command = (Command) command;
			} catch (Exception e) {
				throw new CommandFatalException(e);
			}
			//OK
		}
		return _command.execute(manager, args);
	}

	/*
	 * ( Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return _className;
	}
}