/*
 * 쐬: 2004/12/09
 */
package jp.sourceforge.cafebabe.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.system.CommandQueue;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * R\[̓͂擾܂B
 * @author jin_k
 */
public final class STDInputManager extends InputManager implements Runnable {
	/** VXe}l[WłB */
	private final SystemManager _manager;

	/**
	 * constructor
	 * @param manager VXe}l[W
	 * @param queue ̓L[
	 */
	public STDInputManager(SystemManager manager, CommandQueue queue) {
		super(queue);
		_manager = manager;
		Thread t = new Thread(this);
		t.setDaemon(true);
		t.start();
	}

	/**
	 * run
	 * @see Runnable
	 */
	public void run() {
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					System.in));
			String buff = null;
			while (null != (buff = reader.readLine())) {
				addCommand(buff.trim());
			} //end while
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} finally {
			addCommand(new String[] { "exit" });
		}
	}

	/**
	 * R}hL[ɓo^܂B
	 * @param commandStr R}h
	 */
	private void addCommand(String commandStr) {
		String[] command = commandStr.split(";");
		for (int i = 0; i < command.length; ++i) {
			String com = null;
			if (command[i].startsWith("@")) {
				com = _manager.getMacro(command[i].trim());
				if (null != com) {
					addCommand(com);
					return;
				}
			}
			addCommand(parse(command[i]));
		} //end for
	}

	/**
	 * p[X܂B
	 * @param commandStr R}h
	 * @return p[X
	 */
	private String[] parse(String commandStr) {
		int begin = 0;
		boolean inQuote = false;
		boolean isEscape = false;
		List ret = new ArrayList();
		char[] commands = commandStr.trim().toCharArray();

		for (int i = 0; i <= commandStr.length(); ++i) {
			char c = 0;
			if (i < commandStr.length()) {
				c = commands[i];
			} else {
				//[Iɖ[ɂ
				c = ' ';
				inQuote = false;
			}
			switch (c) {
				case ' ':
					if (inQuote) {
						//NI[gĂ̂Ŗ
					} else {
						//؂̑O܂ł𕶎
						String str = new String(commands, begin, i - begin);
						if (0 < str.length() && !str.equals(" ")) {
							ret.add(str);
						} else {
							//skip
						}
						//Jnʒu炷
						begin = i + 1;
					}
					isEscape = false;
					break;
				case '\\':
					if (isEscape) {
						//'\'̍ăGXP[vȂ̂Ŗ
						isEscape = false;
					} else {
						isEscape = true;
					}
					break;
				case '"':
					if (isEscape) {
						//GXP[vꂽeȂ̂Ŗ
					} else if (inQuote) {
						//͂܂ꂽ͈̖͂[ł
						inQuote = false;
					} else {
						//͈͂̊Jnł
						inQuote = true;
					}
					isEscape = false;
					break;
				default:
					break;
			}
		} //end for
		return (String[]) ret.toArray(new String[ret.size()]);
	}
}