/*
 * 쐬: 2005/05/10
 */
package jp.sourceforge.cafebabe.system;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Stack;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.impl.CommandSetImpl;
import jp.sourceforge.cafebabe.impl.LazyInitializedCommand;
import jp.sourceforge.cafebabe.impl.RootCommandSet;
import jp.sourceforge.cafebabe.util.IOUtil;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * R}hCݒxmlp[X܂B <BR>
 * docs/cafebabe.rngQƂĉB
 * @author jin_k
 */
public final class BabeBuilder extends DefaultHandler {
	/**
	 * XML̃L[`łB
	 * @author jin_k
	 */
	private static interface XMLDefine {
		/** [gvfłB */
		public static final String ROOT = "root";

		/** attribute#name */
		public static final String NAME = "name";

		/** attribute#value */
		public static final String VALUE = "value";

		/** element#envSet */
		public static final String ENV_SET = "envset";

		/** element#env */
		public static final String ENV = "env";

		/** element#commandSet */
		public static final String COMMAND_SET = "commandset";

		/** element#command */
		public static final String COMMAND = "command";

		/** element#class */
		public static final String CLASS = "class";

		/** element#forwardset */
		public static final String FORWARD_SET = "forwardset";

		/** element#forward */
		public static final String FORWARD = "forward";
	}

	/** XMLt@C̊gqłB */
	private static final String XML_EXT = ".xml";

	/** VXe}l[WłB */
	private final SystemManager _manager;

	/** Gg̃X^bNłB */
	private final Stack _elementsStack;

	/** Jg̃R}hZbgłB */
	private CommandSet _currentCommandSet;

	/** Jg̃R}hbpłB */
	private CommandWrapper _currentCommand;

	/** `łB */
	private String _name;

	/**
	 * [gR}hZbgw肵ă[h܂B
	 * @param manager VXe}l[W
	 * @param root [gR}hZbg
	 */
	private BabeBuilder(SystemManager manager, RootCommandSet root) {
		_manager = manager;
		_currentCommandSet = root;
		_currentCommand = root;
		_elementsStack = new Stack();
	}

	/**
	 * 쐬R}hZbgԂ܂B
	 * @return 쐬R}hZbg
	 */
	private RootCommandSet getCreatedSet() {
		if (_currentCommandSet instanceof RootCommandSet) {
			return (RootCommandSet) _currentCommandSet;
		} else {
			throw new RuntimeException();
		}
	}

	/**
	 * commandline.xml R}hZbg𐶐܂B
	 * @param manager VXe}l[W
	 * @param appName commandline.xml ̃pX
	 * @return R}hZbg
	 * @throws Exception p[XO
	 */
	public static final RootCommandSet createBabe(SystemManager manager,
			String appName) throws Exception {
		return createBabe(manager, appName, null);
	}

	/**
	 * commandline.xml R}hZbg𐶐܂B
	 * @param manager VXe}l[W
	 * @param appName commandline.xml ̃pX
	 * @param root [gR}hZbgłB
	 * @return R}hZbg
	 * @throws Exception p[XO
	 */
	public static final RootCommandSet createBabe(SystemManager manager,
			String appName, RootCommandSet root) throws Exception {
		BabeBuilder clBuilder = new BabeBuilder(manager, root);
		SAXParserFactory factory = SAXParserFactory.newInstance();
		SAXParser parser = factory.newSAXParser();

		//VXevpeB擾
		String xmlName = System.getProperty(appName);

		if (null == xmlName) {
			//AvP[V.xml
			xmlName = appName + XML_EXT;
		}

		BufferedInputStream bis = null;
		InputStream is = null;
		try {
			is = Thread.currentThread().getContextClassLoader()
					.getResourceAsStream(xmlName);
			if (null != is) {
				bis = new BufferedInputStream(is);
				parser.parse(bis, clBuilder);
			} else {
				throw new FileNotFoundException("XML file [" + xmlName
						+ "] not found.");
			}
		} finally {
			IOUtil.close(is);
			IOUtil.close(bis);
		}
		return clBuilder.getCreatedSet();
	}

	/*
	 * ( Javadoc)
	 * @see org.xml.sax.ContentHandler#startElement(java.lang.String,
	 *      java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		//Gg
		if (null == qName || qName.equals("")) {
			throw new SAXException("qName == null or \"\"");
		} else if (qName.equals(XMLDefine.ROOT)) {
			//root
			_name = XMLDefine.ROOT;
			//w̏ꍇ̂ݐ
			if (null == _currentCommandSet) {
				_currentCommandSet = new RootCommandSet(_name);
				_currentCommand = _currentCommandSet;
			}
		} else {
			//Ԕf
			if (qName.equals(XMLDefine.ENV)) {
				//ϐZbg̒
				startEnvSet(qName, attributes);
			} else if (qName.equals(XMLDefine.FORWARD)) {
				startForwardSet(attributes);
			} else if (qName.equals(XMLDefine.ENV_SET)) {
				//ignore
			} else if (qName.equals(XMLDefine.FORWARD_SET)) {
				//ignore
			} else if (qName.equals(XMLDefine.COMMAND_SET)) {
				startCommandSet(attributes);
			} else if (qName.equals(XMLDefine.COMMAND)) {
				//R}h
				startCommand(attributes);
			} else {
				throw new SAXException("qName[" + qName + "] is not defined.");
			}
		}
	}

	/**
	 * ϐݒ肵܂B
	 * @param qName qName
	 * @param attributes attributes
	 * @throws SAXException `̃Ggꍇ
	 */
	private void startEnvSet(String qName, Attributes attributes)
			throws SAXException {

		if (qName.equals(XMLDefine.ENV)) {
			//ϐZbg
			_manager.setEnv(attributes.getValue(XMLDefine.NAME), attributes
					.getValue(XMLDefine.VALUE));
		} else {
			throw new SAXException("qName[" + qName + "] is not defined.");
		}
	}

	/**
	 * ߂Jڂݒ肵܂B
	 * @param attributes attributes
	 */
	private void startForwardSet(Attributes attributes) {
		//forwardZbg
		//R}h{
		_currentCommand.setForward(attributes.getValue(XMLDefine.NAME),
				attributes.getValue(XMLDefine.VALUE));
	}

	/**
	 * R}hZbgݒ肵܂B
	 * @param attributes attributes
	 */
	private void startCommandSet(Attributes attributes) {
		//ÕR}hZbgX^bNɐς
		_elementsStack.push(_currentCommandSet);
		CommandSet parent = _currentCommandSet;
		_name = attributes.getValue(XMLDefine.NAME);
		if (parent.containsCommand(_name)
				&& parent.getCommand(_name) instanceof CommandSet) {
			//ɑ݂Ă擾
			_currentCommandSet = (CommandSet) parent.getCommand(_name);
			_currentCommand = _currentCommandSet;
		} else {
			_currentCommandSet = new CommandSetImpl(_name);
			_currentCommandSet.setParent(parent);
			parent.setCommand(_currentCommandSet);
			_currentCommand = _currentCommandSet;
		}
	}

	/**
	 * R}hݒ肵܂B
	 * @param attributes attributes
	 */
	private void startCommand(Attributes attributes) {
		_currentCommand = new LazyInitializedCommand(attributes
				.getValue(XMLDefine.NAME), attributes.getValue(XMLDefine.CLASS));
		_currentCommand.setParent(_currentCommandSet);
		_currentCommandSet.setCommand(_currentCommand);
	}

	/*
	 * ( Javadoc)
	 * @see org.xml.sax.ContentHandler#endElement(java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		//Gg
		if (null == qName || qName.equals("")) {
			throw new SAXException("qName == null or \"\"");
		} else if (qName.equals(XMLDefine.ROOT)) {
			//root
		} else {
			//Ԕf
			if (qName.equals(XMLDefine.ENV_SET)) {
				//ignore
			} else if (qName.equals(XMLDefine.FORWARD_SET)) {
				//ignore
			} else if (qName.equals(XMLDefine.COMMAND_SET)) {
				//ÕR}hZbgX^bN߂
				_currentCommandSet = (CommandSet) _elementsStack.pop();
				_name = _currentCommandSet.getName();
			} else if (qName.equals(XMLDefine.COMMAND)) {
				//߂
				_currentCommand = _currentCommandSet;
			} else if (qName.equals(XMLDefine.ENV)
					|| qName.equals(XMLDefine.FORWARD)) {
				//command/env/forward̖[ƂĉȂ
			} else {
				throw new SAXException("qName[" + qName + "] is not defined.");
			}
		}
	}
}