/*
 * 쐬: 2005/05/25
 */
package jp.sourceforge.cafebabe.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import jp.sourceforge.cafebabe.impl.STDInputManager;
import jp.sourceforge.cafebabe.util.IOUtil;

/**
 * ConsoleApplicationFrameworkExample "Babe" ̃CNXłB
 * @author jin_k
 */
public class CAFEBabe extends Thread {
	/** AvP[VłB */
	private static final String APP_NAME = "cafebabe";

	/** [g̃fBNg\܂B */
	public static final String DIR_ROOT = "cafebabe.directory.root";

	/** OfBNgłB */
	public static final String DIR_LOGS = "cafebabe.directory.logs";

	/** }Nt@CłB */
	private static final String MACRO_FILE = "conf/macro.properties";

	/** NAvP[VłB */
	private final String _appName;

	/** VXe}l[WłB */
	private SystemManager _sm;

	/**
	 * RXgN^BNX[_w肷Kv܂B
	 * @param cl NX[_łB
	 * @param appName AvP[V
	 */
	public CAFEBabe(ClassLoader cl, String appName) {
		_appName = appName;
		setContextClassLoader(cl);
	}

	/**
	 * ܂B
	 * @throws Exception o͗OAXMLp[XO
	 */
	public void init() throws Exception {
		_sm = new SystemManager(_appName);
		_sm.setCommandQueue(new CommandQueue());
		_sm.setInputManager(new STDInputManager(_sm, _sm.getCommandQueue()));

		//\z
		//ŏɃftHgp
		_sm.setRootCommandSet(BabeBuilder.createBabe(_sm, APP_NAME));
		if (!_appName.equals(APP_NAME)) {
			//NAvP[Vɉݒǉ
			BabeBuilder.createBabe(_sm, _appName, _sm.getRootCommandSet());
		}

		//}Nt@C̓ǂݍ
		InputStream in = null;
		BufferedReader br = null;
		try {
			in = getContextClassLoader().getResourceAsStream(MACRO_FILE);
			if (null != in) {
				br = new BufferedReader(new InputStreamReader(in));
				String buff = null;
				while (null != (buff = br.readLine())) {
					String[] macro = buff.split("=");
					if (2 == macro.length) {
						_sm.addMacro(macro[0].trim(), macro[1].trim());
					} else {
						//skip
					}
				} //end while
			} else {
				//skip
			}
		} catch (IOException ioe) {
			//ignore
		} finally {
			IOUtil.close(in);
			IOUtil.close(br);
		}
		//Vbg_EtbN
		final SystemManager sm = _sm;
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				sm.shutdown();
			}
		});
	}

	public void run() {
		try {
			System.out.println("\n\n##");
			System.out.println("## Welcome to \"CAFE Babe\"");
			System.out.println("##");
			System.out.println("");
			_sm.start();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			System.out.println("\n##");
			System.out.println("## Shutdown CAFE Babe... bye");
			System.out.println("##");
		}
	}
}
