package jp.sourceforge.cafebabe.system;

/*
 * 쐬: 2004/12/09
 */
import java.util.LinkedList;

/**
 * R}hi[L[łB
 * @author jin_k
 */
public class CommandQueue {
	/** R}hL[{̂łB */
	private final LinkedList _queue;

	/**
	 * constructor
	 */
	public CommandQueue() {
		_queue = new LinkedList();
	}

	/**
	 * L[ɗvfǉ܂B
	 * @param command R}h
	 */
	public void enqueue(String[] command) {
		synchronized (this._queue) {
			this._queue.addLast(command);
			this._queue.notify();
		} //end syn _queue
	}

	/**
	 * L[vf擾܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @return R}h
	 */
	public String[] dequeue(String msg) {
		synchronized (this._queue) {
			while (true) {
				if (0 < this._queue.size()) {
					String[] ret = (String[]) this._queue.removeFirst();
					if (0 < ret.length) {
						return ret;
					} else {
						//ignore
					}
				}
				try {
					System.out.println("");
					System.out.print(msg);
					System.out.print(" > ");
					this._queue.wait();
				} catch (InterruptedException ie) {
					//ignore
				}
			} //end while
		} //end syn _queue
	}
}