/*
 * 쐬: 2005/05/10
 */
package jp.sourceforge.cafebabe.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.framework.CommandException;
import jp.sourceforge.cafebabe.framework.CommandFatalException;
import jp.sourceforge.cafebabe.framework.CommandSet;
import jp.sourceforge.cafebabe.framework.CommandWrapper;
import jp.sourceforge.cafebabe.framework.InputManager;
import jp.sourceforge.cafebabe.impl.RootCommandSet;

/**
 * VXe}l[WłB <BR>
 * ϐyъe}l[WǗ܂B
 * @author jin_k
 */
public class SystemManager {
	/**
	 * NvpeB̃L[`łB
	 * @author jin_k
	 */
	public static interface BootDefine {
		/** AX^XNɃ}b`Ȃ`܂B */
		public static final String NOT_MATCH_ASTERISK = "cafebabe.forward.notmatchasterisk";
	}

	/** [g̃R}hZbgӖ܂B */
	public static final String ROOT_SET = "root";

	/** IӖ܂B */
	public static final String EXIT = "exit";

	/** AvP[VłB */
	private final String _appName;

	/** R\[͂ꂽR}hi[܂B */
	private CommandQueue _commandQueue;

	/** ̓}l[WłB */
	private InputManager _inputManager;

	/** [g̃R}hZbgłB */
	private RootCommandSet _root;

	/** ϐłB */
	private final Map _env;

	/** }NłB */
	private final Map _macro;

	/** ebpłBB */
	private CommandWrapper _commandWrapper;

	/** Vbg_EIĂ邩ǂ܂B */
	private boolean _isShotdowned;

	/**
	 * RXgN^B
	 * @param appName AvP[V
	 */
	SystemManager(String appName) {
		_appName = appName;
		_env = new HashMap();
		_macro = new HashMap();
	}

	/**
	 * [g̃R}hZbgo^܂B
	 * @param root [g̃R}hZbg
	 */
	void setRootCommandSet(RootCommandSet root) {
		_root = root;
	}

	/**
	 * [g̃R}hZbg擾܂B
	 * @return [g̃R}hZbg
	 */
	public RootCommandSet getRootCommandSet() {
		return _root;
	}

	/**
	 * O[oR}hZbg擾܂B
	 * @return O[õR}hZbg
	 */
	public CommandSet getGlobal() {
		return (CommandSet) _root.getCommand(RootCommandSet.GLOBAL);
	}

	/**
	 * @return _commandQueue ߂܂B
	 */
	public CommandQueue getCommandQueue() {
		return _commandQueue;
	}

	/**
	 * @param queue _commandQueue ݒB
	 */
	void setCommandQueue(CommandQueue queue) {
		_commandQueue = queue;
	}

	/**
	 * ̓}l[W擾܂B
	 * @return ̓}l[W
	 */
	public InputManager getInputManager() {
		return _inputManager;
	}

	/**
	 * ̓}l[Wݒ肵܂B
	 * @param manager ̓}l[W
	 */
	void setInputManager(InputManager manager) {
		_inputManager = manager;
	}

	/**
	 * ϐݒ肵܂B
	 * @param key L[
	 * @param value l
	 */
	public void setEnv(String key, Serializable value) {
		_env.put(key, value);
	}

	/**
	 * ϐ擾܂B
	 * @param key L[
	 * @return L[ɕRtꂽl
	 */
	public Object getEnv(String key) {
		return _env.get(key);
	}

	/**
	 * ͓e擾܂B
	 * @return [U͂̓e
	 */
	public String[] getInput() {
		return getInput(_appName);
	}

	/**
	 * ͓e擾܂B
	 * @param msg [U͂𑣂ۂɕ\郁bZ[W
	 * @return [U
	 */
	public String[] getInput(String msg) {
		return _commandQueue.dequeue(msg);
	}

	/**
	 * R}h̐ebp`܂B
	 * @param parent R}hpX
	 */
	public void setWrapper(CommandWrapper parent) {
		_commandWrapper = parent;
	}

	/**
	 * R}h̐ebp폜܂B
	 */
	public void removeWrapper() {
		_commandWrapper = null;
	}

	/**
	 * ĂяõR}hZbg擾܂B
	 * @return ĂяõR}hZbg
	 */
	public CommandWrapper getWrapper() {
		return _commandWrapper;
	}

	/**
	 * }No^܂B
	 * @param name }N
	 * @param macro }N
	 */
	public void addMacro(String name, String macro) {
		_macro.put(name, macro);
	}

	/**
	 * }N擾܂B
	 * @param name }N
	 * @return }N
	 */
	public String getMacro(String name) {
		return (String) _macro.get(name);
	}

	/**
	 * Jn܂B
	 * @throws CommandFatalException vIȗOꍇ
	 * @throws CommandException Oꍇ
	 */
	protected void start() throws CommandFatalException, CommandException {
		String ret = null;
		do {
			_root.execute(this, new String[] { ROOT_SET });
		} while (null != ret && !ret.equals(SystemManager.EXIT)
				&& !ret.equals(Command.FATAL));

	}

	/**
	 * IɌĂ΂܂B <BR>
	 * Ӑ}IɌĂ΂ꍇyуVbg_EtbNŌĂ΂ꍇ܂B
	 */
	public void shutdown() {
		if (!_isShotdowned) {
			_isShotdowned = true;
		}
	}
}