/*
 * 쐬: 2005/06/12
 */
package jp.sourceforge.cafebabe.psh;

import java.io.File;
import java.io.IOException;

import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.system.CAFEBabe;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * @author jin_k
 */
public class PWD implements Command {

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args) {
		try {
			File current = (File) manager.getEnv(PshDefine.DIR_CURRENT);
			if (null == current) {
				current = new File(System.getProperty(CAFEBabe.DIR_ROOT));
				manager.setEnv(PshDefine.DIR_CURRENT, current);
			}
			System.out.println(current.getCanonicalPath());
		} catch (IOException ioe) {
			return ERROR;
		}
		return SUCCESS;
	}
}
