/*
 * 쐬: 2005/06/15
 */
package jp.sourceforge.cafebabe.cbb;

import java.io.PrintStream;
import java.io.Reader;

import jp.sourceforge.cafebabe.system.SystemManager;

import bsh.ConsoleInterface;

/**
 * @author jin_k
 */
public class BabeBshBridge implements ConsoleInterface {
	/** SystemManager */
	private SystemManager _manager;

	/** command reader */
	private Reader _commandReader;

	/**
	 * RXgN^
	 * @param manager }l[W
	 * @param adapter bshA_v^
	 */
	BabeBshBridge(SystemManager manager, BshAdapter adapter) {
		_manager = manager;
		_commandReader = new CommandReader(_manager, adapter);
	}

	/* ( Javadoc)
	 * @see bsh.ConsoleInterface#getIn()
	 */
	public Reader getIn() {
		return _commandReader;
	}

	/* ( Javadoc)
	 * @see bsh.ConsoleInterface#getOut()
	 */
	public PrintStream getOut() {
		return System.out;
	}

	/* ( Javadoc)
	 * @see bsh.ConsoleInterface#getErr()
	 */
	public PrintStream getErr() {
		return System.err;
	}

	/* ( Javadoc)
	 * @see bsh.ConsoleInterface#println(java.lang.Object)
	 */
	public void println(Object o) {
		_manager.println((null != o) ? o.toString() : "null");
	}

	/* ( Javadoc)
	 * @see bsh.ConsoleInterface#print(java.lang.Object)
	 */
	public void print(Object o) {
		_manager.print((null != o) ? o.toString() : "null");
	}

	/* ( Javadoc)
	 * @see bsh.ConsoleInterface#error(java.lang.Object)
	 */
	public void error(Object o) {
		_manager.errPrintln((null != o) ? o.toString() : "null");
	}

}
