/*
 * 쐬: 2005/06/15
 */
package jp.sourceforge.cafebabe.cbb;

import java.io.Reader;

import jp.sourceforge.cafebabe.framework.CommandManager;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * @author jin_k
 */
public class CommandReader extends Reader {
	/** VXe}l[WłB */
	private SystemManager _manager;

	/** cafebabe - bsh adapter */
	private BshAdapter _adapter;

	/** closed */
	private boolean _isClosed;

	/** char buffer */
	private char[] _buff;

	/** index position */
	private int _pos;

	/**
	 * RXgN^
	 * @param manager VXe}l[W
	 * @param adapter bshA_v^
	 */
	public CommandReader(SystemManager manager, BshAdapter adapter) {
		_manager = manager;
		_adapter = adapter;
		_buff = new char[0];
		_pos = 0;
	}

	/* ( Javadoc)
	 * @see java.io.Reader#close()
	 */
	public void close() {
	//ignore
	}

	/* ( Javadoc)
	 * @see java.io.Reader#read(char[], int, int)
	 */
	public int read(char[] cbuf, int off, int len) {
		try {
			//exit() called		
			if (_isClosed) {
				return -1;
			} else if (_buff.length <= _pos) {
				String command = _manager.getInput(null);
				if (null == command || command.trim().startsWith("exit()")) {
					_isClosed = true;
					return -1;
				} else {
					command += "\n";
					if (command.startsWith("@")) {
						CommandManager cm = _manager.getCommandManager();
						String[] macro = cm.split(command, ' ');
						//}N̊mF
						String com = cm.getMacro(macro[0]);
						if (null != com) {
							//
							_buff = cm.parseMacro(com, macro).toCharArray();
						} else {
							//߂łȂ
							_buff = command.toCharArray();
						}
					} else {
						_buff = command.toCharArray();
					}
				}
				_pos = 0;
			}
			if (_isClosed) {
				_adapter.exit();
				return -1;
			}

			int read = (len - off < _buff.length - _pos) ? len - off
					: _buff.length - _pos;
			System.arraycopy(_buff, _pos, cbuf, off, read);
			_pos += read;
			return read;
		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
	}
}
