package MyCanvas.ClearCanvas;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.media.j3d.*;                   //Java3d

import MyMain.CameraPointingGame;
import MyMain.TextData;

import com.sun.j3d.utils.applet.MainFrame;  //MainFrame
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.universe.*;        //SimpleUniverse
import com.sun.j3d.utils.geometry.*;        //Primitive

import javax.vecmath.*;                     //Point3f,Color3f

import java.awt.image.BufferedImage;
import java.awt.Font;

public class ClearCanvas{

    private SimpleUniverse simpleU;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 10.0);
    public Canvas3D canvas;
    public PickCanvas cnvs=null;
    //private MyOwnCode   code=null;
    
    //I{^
    Transform3D endTfd = null;
    TransformGroup endTg = null;
    Shape3D endShape3D = null;
    //̖ʃ{^
    Transform3D nextTfd = null;
    TransformGroup nextTg = null;
    Shape3D nextShape3D = null;

	//\
	//Ԍo߃~bg
	public static Transform3D timeTF3D ;
	public static TransformGroup timeTFG;

	//@
	public static Transform3D infoTF3D;
	public static TransformGroup infoTFG;
	
    BranchGroup branchG0;

	public float move1 = 0.0f;
	public float move2 = 0.0f;
	public float move3 = 0.0f;
	public static MainFrame frame;
	
	CameraPointingGame cameraPointingGame;

    public ClearCanvas(CameraPointingGame cameraPointingGame){

    	this.cameraPointingGame = cameraPointingGame;

        canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        canvas.setBounds(0,0,1024,768);

        simpleU = new SimpleUniverse(canvas);
        simpleU.getViewingPlatform().setNominalViewingTransform();

        simpleU.addBranchGraph(createSceneGraph());
    }
    
	public void prepareText(){
        
        timeTF3D = new Transform3D();
        timeTF3D.setTranslation(new Vector3f(-0.5f, 0.1f, 0.0f));
		timeTFG = new TransformGroup(timeTF3D);  
        createText(timeTFG, TextData.CLEAR_TIME);
        branchG0.addChild(timeTFG);
        
        infoTF3D = new Transform3D();
        infoTF3D.setTranslation(new Vector3f(-0.9f, -0.7f, 0.0f));
        infoTFG = new TransformGroup(infoTF3D);  
        createText(infoTFG, TextData.MENU_NEXT_AND_EXIT);
        branchG0.addChild(infoTFG);
	}

    private void createText(TransformGroup tg, String str){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.1f,0.1f,0.4f),
    			TextData.FONT,
    			18,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
    private BranchGroup createSceneGraph(){

        branchG0 = new BranchGroup();

		// wi̐ݒ
		BufferedImage someImage = null;
		try {
			someImage = ImageIO.read(new File("res/gameback_bokashi.png"));
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		ImageComponent2D image = new ImageComponent2D(
				ImageComponent2D.FORMAT_RGB, someImage);
		Background background = new Background(image);
		// Background background = new Background(new Color3f(0.8f, 0.9f,
		// 1.0f));
		background.setApplicationBounds(bounds);
		branchG0.addChild(background);

        //createPolygon(branchG0,endTfd,endTg,endShape3D,"end",0.8f);

        //createPolygon(branchG0,endTfd,endTg,nextShape3D,"next",0.6f);
        
        ClearCanvasBehavior myBehavior3 = new ClearCanvasBehavior(timeTFG,cameraPointingGame);
        myBehavior3.setSchedulingBounds(bounds);
        branchG0.addChild(myBehavior3);


        //eLXg\
        prepareText();


        branchG0.compile();

        return branchG0;
    }

    public void destroy(){

        simpleU.cleanup();
    }


}

 