package MyCanvas.GameCanvas;
import javax.vecmath.Color3f;
import javax.media.j3d.*;                   //Java3d

import MyMain.TextData;

import com.sun.j3d.utils.geometry.*;        //Primitive
import com.sun.j3d.utils.image.TextureLoader;

import javax.vecmath.*;                     //Point3f,Color3f

import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Random;
public class EnemyData {
	
	public Transform3D tfd;
	public TransformGroup tg;
	
	public AutoTurnEnemy autoTurnEnemy;
	
	public Shape3D shape3D;

	public String name;
	
	//\
	//G̐
	public static Transform3D enemyCountTF3D ;
	public static TransformGroup enemyCountTFG;
	
	//Ԍo߃~bg
	public static Transform3D timeTF3D ;
	public static TransformGroup timeTFG;
	
	//EE㋉
	public static Transform3D levelTF3D;
	public static TransformGroup levelTFG;

	//@
	public static Transform3D infoTF3D;
	public static TransformGroup infoTFG;

	public static GameTimer gametimer;
	
	public CpLock cpLock;
	
	public MyGunSound myGunSound;
	
	public int enemyNum = 0;
	
	public EnemyData(String name, Transform3D tfd, TransformGroup tfg){
		
		this.name = name;
		this.tfd = tfd;
		this.tg = tfg;
		this.cpLock = new CpLock();
		
		this.myGunSound = new MyGunSound();
		//autoTurnEnemy = new AutoTurnEnemy(this.tfd, this.tg, this.cpLock);
		//autoTurnEnemy.autoTurnStart();
	}
	
	public static void prepareText(BranchGroup bg){
		
		FiveRoundData.setRoundOne();
		
		enemyCountTF3D = new Transform3D();
		enemyCountTF3D.setTranslation(new Vector3f(-0.9f, 0.6f, 0.01f));
		enemyCountTFG = new TransformGroup(enemyCountTF3D);
        createText(enemyCountTFG, TextData.GAME_ENEMY_NUM);
        bg.addChild(enemyCountTFG);
        
        timeTF3D = new Transform3D();
        timeTF3D.setTranslation(new Vector3f(-0.4f, 0.6f, 0.0f));
        timeTFG = new TransformGroup(timeTF3D);  
        createText(timeTFG, TextData.GAME_TIME);
        bg.addChild(timeTFG);
        
        levelTF3D = new Transform3D();
        levelTF3D.setTranslation(new Vector3f(0.2f, 0.6f, 0.0f));
        levelTFG = new TransformGroup(levelTF3D);  
        createText(levelTFG, TextData.GAME_LEVEL_LOW);
        bg.addChild(levelTFG);
        
        infoTF3D = new Transform3D();
        infoTF3D.setTranslation(new Vector3f(-0.9f, -0.7f, 0.0f));
        infoTFG = new TransformGroup(infoTF3D);  
        createText(infoTFG, TextData.MENU_SHOT_AND_EXIT);
        bg.addChild(infoTFG);
        
        gametimer = new GameTimer(timeTFG);
        //gametimer.timerStart();
	}

    private static void createText(TransformGroup tg, String str){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.1f,0.1f,0.4f),
    			TextData.FONT,
    			18,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
	
    public static void changeText(TransformGroup tg, String str){
 
    	((Text2D)(tg.getChild(0))).setString(str);
    }
    
    public void startAutoTurnEnemy(){
		autoTurnEnemy = new AutoTurnEnemy(this.tfd, this.tg, this.cpLock, this.shape3D,this);
		autoTurnEnemy.autoTurnStart();
    }
	public void hit()
	{
		System.out.println(name);
		
		this.myGunSound.gunPlay();
		
		if ((enemyNum == 0) || (enemyNum == 1)){
			FiveRoundData.enemyCount += 1;
		}
		else {
			FiveRoundData.enemyCount -= 1;
		}
	     
        //]XbhJn
		RotateAnimThread rat = new RotateAnimThread();
        if (rat.startThread(tfd, tg, this.cpLock) == false)
        	return;
        
        
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        
        Random rnd = new Random();

        int ran = rnd.nextInt(5);
        enemyNum  = ran;
        
        Image image = toolkit.getImage("res/" + String.valueOf(ran) + ".png");
        TextureLoader loader = new TextureLoader(image, null);
    	
        shape3D.getAppearance().setTexture(loader.getTexture());
        
        //FiveRoundData.enemyCount -= 1;
        changeText(enemyCountTFG, TextData.GAME_ENEMY_NUM2  + String.valueOf(FiveRoundData.enemyCount));
	}
}
