package MyMain;

import Cameus.*;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import org.opencv.core.Mat;
import org.opencv.highgui.VideoCapture;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDevice;

public class GetCameraNumber{

	JFrame frame;
	JButton submitBtn;
	JButton noCamBtn;

	JLabel infoLabel;
	JLabel infoLabel2;
	JLabel infoLabel3;

	@SuppressWarnings("rawtypes")
	javax.swing.JList jList;

	String[] camList;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public GetCameraNumber() {

		camList = new String[10];

		List<WebcamDevice> webcam = Webcam.getDriver().getDevices();
		int numDevs = webcam.size();
		
		for (int i = 0; i < numDevs; i++) {
			camList[i] = webcam.get(i).getName();
		}

		frame = new JFrame();
		frame.setTitle(TextData.GETCAMNUM_TITLE);
		frame.setBounds(300, 300, 500, 500);
		//frame.setModal(true);

		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLayout(null);
		frame.setResizable(false);

		infoLabel = new JLabel();
		infoLabel.setText(TextData.GETCAMNUM_LINE1);
		infoLabel.setBounds(10, 10, 400, 30);
		frame.add(infoLabel);

		infoLabel2 = new JLabel();
		infoLabel2.setText(TextData.GETCAMNUM_LINE2);
		infoLabel2.setBounds(10, 40, 400, 30);
		frame.add(infoLabel2);

		infoLabel3 = new JLabel();
		infoLabel3.setText(TextData.GETCAMNUM_LINE3);
		infoLabel3.setBounds(10, 70, 400, 30);
		frame.add(infoLabel3);

		jList = new JList(camList);
		jList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jList.setBounds(2, 160, 490, 250);
		jList.setVisible(true);

		frame.add(jList);
		
		noCamBtn = new JButton();
		noCamBtn.setText(TextData.GETCAMNUM_NO_CAMERA_BUTTON);
		noCamBtn.setBounds(260, 430, 200, 30);
		noCamBtn.addActionListener(new NoCamAction("jList", jList, frame));
		noCamBtn.setVisible(true);
		
		submitBtn = new JButton();
		submitBtn.setText(TextData.GETCAMNUM_SELECT_BUTTON);
		submitBtn.setBounds(70, 430, 180, 30);
		submitBtn.addActionListener(new SubmitAction("jList", jList, frame,
				submitBtn,noCamBtn));
		submitBtn.setVisible(true);

		frame.add(submitBtn);



		frame.add(noCamBtn);

		frame.toFront();

		frame.setVisible(true);
		
	}

	@SuppressWarnings("serial")
	static class SubmitAction extends AbstractAction {

		private JButton button;
		private JButton button2;
		private JFrame frame;

		@SuppressWarnings("rawtypes")
		private JList jList;
		private int[] num;

		@SuppressWarnings("rawtypes")
		public SubmitAction(String newName, JList newJList, JFrame frame,
				JButton button,JButton button2) {
			this.jList = newJList;
			this.button = button;
			this.button2 = button2;
			this.frame = frame;
		}

		@Override
		public void actionPerformed(ActionEvent e) {

			this.num = this.jList.getSelectedIndices();

			if (this.num.length == 0) {
				//System.out.println("IĂ܂");
				KameusThread.CameraDeviceNumber = 100;
			} else if (this.num.length == 1) {
				KameusThread.CameraDeviceNumber = this.num[0];
				System.out.println(this.jList.getSelectedValue().toString()
						+ " : " + String.valueOf(this.num[0]));



			    Thread t = new Thread(new Runnable() {
			        public void run() {
			        	CheckDevice();
			        }
			    });

			    t.start();

			} else {
				System.out.println("O");
				KameusThread.CameraDeviceNumber = 100;
			}

		}

		public void CheckDevice() {
			
			this.button.setText(TextData.GETCAMNUM_CHECKING_BUTTON);
			this.button.setEnabled(false);
			this.button2.setEnabled(false);
			VideoCapture capture = null;
			try {
				Mat capImg = new Mat();
				capture = new VideoCapture(
						KameusThread.CameraDeviceNumber);

				if (capture.isOpened() == false) {
					// return false;
				}

				capture.set(4, 720);
				capture.set(3, 1280);
				capture.read(capImg);
				if ((capImg.width() == 1280) && (capImg.height() == 720)) {
					System.out.println("Camera is 1280x720");
					capture.release();
					new CameraPointingGame();
					frame.dispose();
				} else {

					capture.set(4, 480);
					capture.set(3, 640);
					capture.read(capImg);
					if ((capImg.width() == 640) && (capImg.height() == 480)) {
						System.out.println("Camera is 640x480");
						capture.release();
						javax.swing.JOptionPane.showMessageDialog(null,TextData.GETCAMNUM_MESSAGE);
						this.button.setText(TextData.GETCAMNUM_SELECT_BUTTON);
						this.button.setEnabled(true);
						this.button2.setEnabled(true);
					}
				}

			} catch (Exception e) {
				System.out.println("xxxx" + e);
				java.lang.System.exit(0);
			} finally {
				System.out.println("xxxx");
			}
			try{
				capture.release();
			}catch(Exception e){
				
			}
		}
	}

	@SuppressWarnings("serial")
	static class NoCamAction extends AbstractAction {

		private JFrame frame;

		@SuppressWarnings("rawtypes")
		public NoCamAction(String newName, JList newJList, JFrame frame) {
			this.frame = frame;
		}

		@Override
		public void actionPerformed(ActionEvent e) {
			KameusThread.CameraDeviceNumber = 100;
			new CameraPointingGame();
			frame.dispose();
			// CameraPointingGame.frame = new MainFrame(new
			// CameraPointingGame(), 1024,768);
		}
	}
}