package MyCanvas.LoadingCanvas;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

import java.io.File;
import java.io.IOException;

import javax.media.j3d.*;                   //Java3d

import MyMain.CameraPointingGame;
import MyMain.TextData;

import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.universe.*;        //SimpleUniverse
import com.sun.j3d.utils.geometry.*;        //Primitive

import javax.vecmath.*;                     //Point3f,Color3f

import java.awt.image.BufferedImage;
import java.awt.Font;

import javax.imageio.ImageIO;

public class LoadingCanvas{

    private SimpleUniverse simpleU;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 10.0);
    public Canvas3D canvas;
    public PickCanvas cnvs=null;


	//\
	//Ԍo߃~bg
	public static Transform3D nowLoadingTF3D ;
	public static TransformGroup nowLoadingTFG;
	
    BranchGroup branchG0;
	
	CameraPointingGame cameraPointingGame;

    public LoadingCanvas(CameraPointingGame cameraPointingGame){

    	this.cameraPointingGame = cameraPointingGame;

        canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        
        canvas.setBounds(0, 0,1024,768);
        
        simpleU = new SimpleUniverse(canvas);
        simpleU.getViewingPlatform().setNominalViewingTransform();

        simpleU.addBranchGraph(createSceneGraph());
    }
    
	public void prepareText(){
        
		nowLoadingTF3D = new Transform3D();
		nowLoadingTF3D.setTranslation(new Vector3f(-0.8f, 0.4f, 0.0f));
		nowLoadingTFG = new TransformGroup(nowLoadingTF3D);  
		createLoadingText(nowLoadingTFG, "NOW LOADING...");
        branchG0.addChild(nowLoadingTFG);
	}

    private void createLoadingText(TransformGroup tg, String str){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.1f,0.1f,0.4f),
    			TextData.FONT,
    			14,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
    
    
    private BranchGroup createSceneGraph(){

        branchG0 = new BranchGroup();

        //wi̐ݒ		
		BufferedImage someImage = null;
		try {
			someImage = ImageIO.read(new File("res/gameback.png"));
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
    	ImageComponent2D image=new ImageComponent2D(
    			ImageComponent2D.FORMAT_RGB,someImage);
    	Background background=new Background(image);
    	
        //Background background = new Background(new Color3f(0.8f, 0.9f, 1.0f));
        background.setApplicationBounds(bounds);
        branchG0.addChild(background);
        
        
        LoadingCanvasBehavior myBehavior3 = new LoadingCanvasBehavior(nowLoadingTFG,cameraPointingGame);
        myBehavior3.setSchedulingBounds(bounds);
        branchG0.addChild(myBehavior3);
        
        //eLXg\
        prepareText();


        branchG0.compile();

        return branchG0;
    }

    public void destroy(){

        simpleU.cleanup();
    }


}

 