package MyCanvas.StartCanvas;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import javax.media.j3d.*;                   //Java3d

import MyMain.CameraPointingGame;
import MyMain.TextData;

import com.sun.j3d.utils.applet.MainFrame;  //MainFrame
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.universe.*;        //SimpleUniverse
import com.sun.j3d.utils.geometry.*;        //Primitive

import javax.vecmath.*;                     //Point3f,Color3f

import java.awt.image.BufferedImage;
import java.awt.Font;

import javax.imageio.ImageIO;

import java.io.File;
import java.io.IOException;

public class StartCanvas{

    private SimpleUniverse simpleU;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 10.0);
    public Canvas3D canvas;
    public PickCanvas cnvs=null;
    //private MyOwnCode   code=null;
    
    //I{^
    Transform3D endTfd = null;
    TransformGroup endTg = null;
    Shape3D endShape3D = null;
    //̖ʃ{^
    Transform3D nextTfd = null;
    TransformGroup nextTg = null;
    Shape3D nextShape3D = null;

	//\
	//Ԍo߃~bg
	public static Transform3D titleTF3D ;
	public static TransformGroup titleTFG;

	//@
	public static Transform3D infoTF3D;
	public static TransformGroup infoTFG;
	
    BranchGroup branchG0;

	public float move1 = 0.0f;
	public float move2 = 0.0f;
	public float move3 = 0.0f;
	public static MainFrame frame;
	
	CameraPointingGame cameraPointingGame;
	
	public MyCanvas.StartCanvas.MySound myStartCanvasSound = new MyCanvas.StartCanvas.MySound();

    public StartCanvas(CameraPointingGame cameraPointingGame){

    	this.cameraPointingGame = cameraPointingGame;
        //Avbg̒Canvas3Dǉ
        //setLayout(new BorderLayout());
        canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        canvas.setBounds(0,0,1024,768);

        simpleU = new SimpleUniverse(canvas);
        simpleU.getViewingPlatform().setNominalViewingTransform();

        simpleU.addBranchGraph(createSceneGraph());
    }
    
	public void prepareText(){
        
        titleTF3D = new Transform3D();
        titleTF3D.setTranslation(new Vector3f(-0.7f, 0.0f, 0.0f));
        titleTFG = new TransformGroup(titleTF3D);  
        createTitleText(titleTFG, "CameraPointingGame",40);
        branchG0.addChild(titleTFG);
        
        infoTF3D = new Transform3D();
        infoTF3D.setTranslation(new Vector3f(-0.9f, -0.7f, 0.0f));
        infoTFG = new TransformGroup(infoTF3D);  
        createText(infoTFG, TextData.MENU_START_AND_EXIT,18);
        branchG0.addChild(infoTFG);
	}
    private void createTitleText(TransformGroup tg, String str, int size){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.9f,0.9f,1.0f),
    			"Serif",
    			size,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
    private void createText(TransformGroup tg, String str, int size){
    	Text2D text2d = new Text2D(
    			str,
    			new Color3f(0.1f,0.1f,0.4f),
    			TextData.FONT,
    			size,
    			Font.BOLD);
    	

        Appearance app = text2d.getAppearance();
        app.setCapability(Appearance.ALLOW_TEXTURE_READ);
        app.setCapability(Appearance.ALLOW_TEXTURE_WRITE);
    	tg.addChild(text2d);
    }
    private BranchGroup createSceneGraph(){

        branchG0 = new BranchGroup();

        //wi̐ݒ
		//Toolkit toolkit = Toolkit.getDefaultToolkit();
		BufferedImage someImage = null;
		try {
			someImage = ImageIO.read(new File("res/title.png"));
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
    	ImageComponent2D image=new ImageComponent2D(
    			ImageComponent2D.FORMAT_RGB,someImage);
    	Background background=new Background(image);
        //Background background = new Background(new Color3f(0.8f, 0.9f, 1.0f));
        background.setApplicationBounds(bounds);
        branchG0.addChild(background);
        
        StartCanvasBehavior myBehavior3 = new StartCanvasBehavior(titleTFG,cameraPointingGame);
        myBehavior3.setSchedulingBounds(bounds);
        branchG0.addChild(myBehavior3);


        //eLXg\
        prepareText();


        branchG0.compile();

        return branchG0;
    }

    public void destroy(){

        simpleU.cleanup();
    }


}

 