/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.indexer.ShortIndexer;

public class ShortBufferIndexer
extends ShortIndexer {
    protected ShortBuffer buffer;

    public ShortBufferIndexer(ShortBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public short get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public ShortIndexer get(int i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public short get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public ShortIndexer get(int i, int j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public short get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public short get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public ShortIndexer get(int[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public ShortIndexer put(int i, short s) {
        this.buffer.put(i, s);
        return this;
    }

    @Override
    public ShortIndexer put(int i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, s[offset + n]);
        }
        return this;
    }

    @Override
    public ShortIndexer put(int i, int j, short s) {
        this.buffer.put(i * this.strides[0] + j, s);
        return this;
    }

    @Override
    public ShortIndexer put(int i, int j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, s[offset + n]);
        }
        return this;
    }

    @Override
    public ShortIndexer put(int i, int j, int k, short s) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, s);
        return this;
    }

    @Override
    public ShortIndexer put(int[] indices, short s) {
        this.buffer.put(this.index(indices), s);
        return this;
    }

    @Override
    public ShortIndexer put(int[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, s[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

