/*
 * Decompiled with CFR 0.152.
 */
package hayashi.yuu.register;

import hayashi.yuu.register.CardRegister;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.co.areaweb.tools.csv.CsvRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CollectData {
    public Calendar date = Calendar.getInstance();
    public String address = null;
    public String name = null;
    public String data = "";
    public static Calendar baseDate = null;
    public static String[] columnNames = new String[]{"\u65e5\u6642", "\u30ab\u30fc\u30c9ID", "\u9001\u4fe1\u5148\u30a2\u30c9\u30ec\u30b9", "\u306a\u307e\u3048"};
    static final String DATETIME_PATTERN = "yyyy/MM/dd'-'HH:mm:ss";
    static SimpleDateFormat dateTimePattern = new SimpleDateFormat("yyyy/MM/dd'-'HH:mm:ss");

    public CollectData(Date datetime, String data, String address, String name) {
        this.date.setTime(datetime);
        if (this.date.get(1) < 2000) {
            if (baseDate != null) {
                this.date.set(baseDate.get(1), baseDate.get(2), baseDate.get(5));
            }
        } else {
            baseDate = Calendar.getInstance();
            baseDate.set(this.date.get(1), this.date.get(2), this.date.get(5));
        }
        this.data = data;
        this.address = address == null ? this.getAddress(data) : address;
        this.name = name == null ? this.getName(data) : name;
    }

    public CollectData(Date datetime, String data) {
        this(datetime, data, null, null);
    }

    public Element getXmlElement(Document document) {
        Element point = document.createElement("point");
        point.setAttribute("id", this.data);
        point.setAttribute("datetime", dateTimePattern.format(this.date.getTime()));
        Element addrEle = document.createElement("address");
        addrEle.appendChild(document.createTextNode(this.address));
        point.appendChild(addrEle);
        Element nameEle = document.createElement("name");
        nameEle.appendChild(document.createTextNode(this.name));
        point.appendChild(nameEle);
        return point;
    }

    public String[] getRecordStrs() {
        String[] strs = new String[]{dateTimePattern.format(this.date.getTime()), this.data, this.address, this.name};
        return strs;
    }

    public String getAddress(String dataStr) {
        if (CardRegister.taglistFile == null) {
            return "";
        }
        for (CsvRecord record : CardRegister.taglistFile) {
            String idStr = (String)record.get(0);
            if (!idStr.equals(dataStr)) continue;
            return (String)record.get(1);
        }
        return "";
    }

    public String getName(String dataStr) {
        if (CardRegister.taglistFile == null) {
            return "";
        }
        for (CsvRecord record : CardRegister.taglistFile) {
            String idStr = (String)record.get(0);
            if (!idStr.equals(dataStr)) continue;
            try {
                String ret = (String)record.get(2);
                return ret;
            }
            catch (IndexOutOfBoundsException ioobe) {
                return "";
            }
        }
        return "";
    }
}

