<?php
/*
 * Actung Baby - Kids Class by Yoshi Sakai ( a.k.a bluemoon )
 */
include_once "./class/commonView.php";
include_once "./class/commonCtrl.php";

class ActionHandler {
	var $mTable = "cartb2b_category";
	var $mPrimary = "gcid";
	var $records = array();
	var $debstr="";
	var $message="";
	var $gcid=0;
	var $formInput=array();
	/*
	 *  Initial Handler Section
	 */	
	function ActionHandler($ctrl=""){
		$this->getParam();
		switch($ctrl){
			case "category_addnew":
				$this->ctrl = "addnew" ;
				break;
			case "category_edit":
				$this->ctrl = "edit" ;
				break;
		}		
	}
	/*
	 *  Global Task Section
	 */	
	function load(){
		global $xoopsDB;

		$myts =& MyTextSanitizer::getInstance();	
		if ($this->ctrl=="addnew") return 1;
		$sql = "SELECT * FROM " . $xoopsDB->prefix( $this->mTable );
		if ($this->gcid) $sql .= " WHERE gcid=" . $this->gcid;
		$result = $xoopsDB->query( $sql ) ;
		$view = new commonView();
		$this->records = array();
		while( $myrow = $xoopsDB->fetchArray($result) ){
			$myrow['image'] = $view->makeUploadFileUrl($myrow['image']);
			$myrow['content4edit'] = $myts->makeTareaData4Edit(stripslashes($myrow['content']));
			$myrow['content'] = $myts->makeTareaData4Show(stripslashes($myrow['content']));
			$this->records[] = $myrow;
		}
		$this->debstr .= $sql."<br />";
		return $result;
	}
	function assignRecords(){
		global $xoopsTpl;
		$debstr = "";	//$this->debstr;
		$xoopsTpl->assign( 'debstr', $debstr );		// assign debug strings
		$xoopsTpl->assign( 'message', $this->message );
		$xoopsTpl->assign( 'ctrl', $this->ctrl );
		$xoopsTpl->assign( 'records', $this->records );
	}
	function debug(){
		return $this->debstr;
	}
	/*
	 *  Private Task Section
	 */	
	private function getParam(){
		global $xoopsUser;
		$this->gcid = isset($_GET['gcid']) ? intval($_GET['gcid']) : 0;
		$this->gcid = isset($_POST['gcid']) ? intval($_POST['gcid']) : $this->gcid;
		$this->formInput['parent'] = isset($_POST['parent']) ? intval($_POST['parent']) : 0;
		$this->formInput['weight'] = isset($_POST['weight']) ? intval($_POST['weight']) : 0;
		$this->formInput['title'] = isset($_POST['title']) ? htmlspecialchars($_POST['title'],ENT_QUOTES) : "";
		$this->formInput['image'] = isset($_POST['image']) ? htmlspecialchars($_POST['image'],ENT_QUOTES) : "";
		$this->formInput['content'] = isset($_POST['content']) ? $_POST['content'] : "";
		$ctrl = new commonCtrl();
		$ctrl->getUploadFiles($_FILES,'file_image');
		if (isset($ctrl->getUploadFileName[0])) $this->formInput['image'] = $ctrl->getUploadFileName[0];
	}
	private function insert(){
		global $xoopsDB, $xoopsUser;

		$myts =& MyTextSanitizer::getInstance();	
		$rec = $this->formInput;
		foreach ($rec as $key => $val) {
			 $rec[$key] = '"' . $myts->addSlashes($val) . '"';
		}
		$rec["crtdate"] = $rec["lupdate"] = '"'. time() . '"';
		$sql ="INSERT INTO ".$xoopsDB->prefix($this->mTable)
			." (".implode(",", array_keys($rec)).") VALUES(".implode(",", array_values($rec)).")";
		$this->debstr .= $sql."<br />";
		$result = $xoopsDB->query( $sql );
		if ($result){
			$this->gcid = $xoopsDB->getInsertID(); 
		}
		return $result;
	}
	private function update(){
		global $xoopsDB;

		$myts =& MyTextSanitizer::getInstance();	
		$rec = $this->formInput;
		foreach ($rec as $key => $val) {
			 $rec[$key] = '"' . $myts->addSlashes($val) . '"';
		}
		$rec["lupdate"] = '"'. time() . '"';
		$sql = "UPDATE ".$xoopsDB->prefix($this->mTable) . " SET ";
		$i=0;
		foreach ($rec as $key=>$val ){
			if ($i>0) $sql .= ",";
			$sql .= " " . $key . "=" . $val;
			$i++;
		}
		$sql .= " WHERE gcid=" . $this->gcid;
		$result = $xoopsDB->query( $sql );
		$this->debstr .= $sql."<br />";
		return $result;
	}
	private function delete(){
		global $xoopsDB;
		$sql = "DELETE FROM ".$xoopsDB->prefix($this->mTable) . " WHERE gcid=" . $this->gcid;
		$result = $xoopsDB->query( $sql );
		$this->debstr .= $sql."<br />";
		return $result;
	}
	/*
	 *  Controller Driven Section
	 */
	function category_insert(){
		$ret = $this->insert();
		$this->load();
		$this->message = _MD_CARTB2B_ADDNEWDONE;
		$this->ctrl = "edit";
		return 1;
	}	
	function category_addnew(){
		$this->ctrl = "insert";
		return 1;
	}
	function category_update(){
		$ret = $this->update();
		$this->load();
		$this->message = _MD_CARTB2B_UPDATEDONE;
		$this->ctrl = "edit";
		return 1;
	}	
	function category_edit(){
		$this->ctrl = "update";
		return 1;
	}	
	function category_deleteOk(){
		$ret = $this->delete();
		$this->gcid = 0;
		$this->ctrl = "";
		$this->message = _MD_CARTB2B_DELETEDONE;
		$this->load();
		return 1;
	}	
	function category_delete(){
		$this->ctrl = "deleteOk";
		return 1;
	}	
}
?>